/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.tasks;

import de.huxhorn.sulky.io.IOUtilities;
import de.huxhorn.sulky.tasks.ProgressingCallable;
import de.huxhorn.sulky.tasks.Task;
import de.huxhorn.sulky.tasks.TaskListener;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskManager<T> {
    private final Logger logger = LoggerFactory.getLogger(TaskManager.class);
    private final ReentrantReadWriteLock tasksLock;
    private final ReentrantReadWriteLock taskListenersLock;
    private boolean usingEventQueue;
    private final ExecutorService executorService;
    private final List<Task<T>> internalCreatedTasks;
    private final Map<Long, Task<T>> tasks;
    private final Map<Integer, Task<T>> callableTasks;
    private final List<ProgressChange<T>> internalProgressChanges;
    private long nextTaskId;
    private final List<TaskListener<T>> taskListeners;
    private final PropertyChangeListener progressChangeListener;
    private Thread resultPollerThread;
    private State state;

    public TaskManager() {
        this(Executors.newCachedThreadPool(), false);
    }

    public TaskManager(ExecutorService executorService) {
        this(executorService, false);
    }

    public TaskManager(ExecutorService executorService, boolean usingEventQueue) {
        if (executorService == null) {
            throw new IllegalArgumentException("executorService must not be null!");
        }
        this.tasksLock = new ReentrantReadWriteLock(true);
        this.taskListenersLock = new ReentrantReadWriteLock(true);
        this.nextTaskId = 1L;
        this.usingEventQueue = usingEventQueue;
        this.internalCreatedTasks = new ArrayList<Task<T>>();
        this.tasks = new HashMap<Long, Task<T>>();
        this.callableTasks = new HashMap<Integer, Task<T>>();
        this.progressChangeListener = new ProgressChangeListener();
        this.internalProgressChanges = new ArrayList<ProgressChange<T>>();
        this.taskListeners = new LinkedList<TaskListener<T>>();
        this.executorService = executorService;
        this.state = State.INITIALIZED;
    }

    public void startUp() {
        if (this.state != State.INITIALIZED) {
            throw new IllegalStateException("You tried to start a task manager but it's state was " + (Object)((Object)this.state) + " instead of INITIALIZED!");
        }
        this.resultPollerThread = new Thread((Runnable)new TaskResultPoller(), "TaskResultPoller");
        this.resultPollerThread.setDaemon(true);
        this.resultPollerThread.start();
        this.state = State.RUNNING;
    }

    public void shutDown() {
        if (this.state == State.RUNNING) {
            this.state = State.STOPPED;
            this.resultPollerThread.interrupt();
            this.executorService.shutdownNow();
        }
    }

    public State getState() {
        return this.state;
    }

    public Task<T> startTask(Callable<T> callable, String name) {
        return this.startTask(callable, name, null, null);
    }

    public Task<T> startTask(Callable<T> callable, String name, String description) {
        return this.startTask(callable, name, description, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<T> startTask(Callable<T> callable, String name, String description, Map<String, String> metaData) {
        TaskImpl<T> task;
        if (this.state != State.RUNNING) {
            throw new IllegalStateException("You tried to start a task but the task managers state was " + (Object)((Object)this.state) + " instead of RUNNING!");
        }
        if (name == null) {
            throw new IllegalArgumentException("name must not be null!");
        }
        if (callable instanceof ProgressingCallable) {
            ProgressingCallable pcallable = (ProgressingCallable)callable;
            pcallable.addPropertyChangeListener(this.progressChangeListener);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Added progress change listener to callable.");
            }
        }
        int callableIdentity = System.identityHashCode(callable);
        Future<T> future = this.executorService.submit(callable);
        ReentrantReadWriteLock.WriteLock lock = this.tasksLock.writeLock();
        lock.lock();
        try {
            if (this.callableTasks.containsKey(callableIdentity)) {
                throw new IllegalArgumentException("Callable is already scheduled!");
            }
            long newId = this.nextTaskId++;
            task = new TaskImpl<T>(newId, this, future, callable, name, description, metaData);
            this.internalCreatedTasks.add(task);
            this.tasks.put(newId, task);
            this.callableTasks.put(callableIdentity, task);
        }
        finally {
            lock.unlock();
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfTasks() {
        ReentrantReadWriteLock.ReadLock lock = this.tasksLock.readLock();
        lock.lock();
        try {
            int n = this.tasks.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<T> getTaskById(long taskId) {
        ReentrantReadWriteLock.ReadLock lock = this.tasksLock.readLock();
        lock.lock();
        try {
            Task<T> task = this.tasks.get(taskId);
            return task;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<T> getTaskByCallable(Callable<T> callable) {
        int callableIdentity = System.identityHashCode(callable);
        ReentrantReadWriteLock.ReadLock lock = this.tasksLock.readLock();
        lock.lock();
        try {
            Task<T> task = this.callableTasks.get(callableIdentity);
            return task;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Task<T>> getTasks() {
        HashMap<Long, Task<T>> result;
        ReentrantReadWriteLock.ReadLock lock = this.tasksLock.readLock();
        lock.lock();
        try {
            result = new HashMap<Long, Task<T>>(this.tasks);
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    public boolean isUsingEventQueue() {
        return this.usingEventQueue;
    }

    public void setUsingEventQueue(boolean usingEventQueue) {
        this.usingEventQueue = usingEventQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskListener(TaskListener<T> listener) {
        ReentrantReadWriteLock.WriteLock lock = this.taskListenersLock.writeLock();
        lock.lock();
        try {
            this.taskListeners.add(listener);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskListener(TaskListener<T> listener) {
        ReentrantReadWriteLock.WriteLock lock = this.taskListenersLock.writeLock();
        lock.lock();
        try {
            this.taskListeners.remove(listener);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TaskImpl<V>
    implements Task<V> {
        private final long id;
        private final TaskManager<V> taskManager;
        private final Future<V> future;
        private final Callable<V> callable;
        private final String name;
        private final String description;
        private final Map<String, String> metaData;

        public TaskImpl(long id, TaskManager<V> taskManager, Future<V> future, Callable<V> callable, String name, String description, Map<String, String> metaData) {
            this.id = id;
            this.taskManager = taskManager;
            this.callable = callable;
            this.future = future;
            this.name = name;
            this.description = description;
            this.metaData = metaData != null ? new HashMap<String, String>(metaData) : null;
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Map<String, String> getMetaData() {
            if (this.metaData == null) {
                return null;
            }
            return Collections.unmodifiableMap(this.metaData);
        }

        @Override
        public Future<V> getFuture() {
            return this.future;
        }

        @Override
        public Callable<V> getCallable() {
            return this.callable;
        }

        @Override
        public TaskManager<V> getTaskManager() {
            return this.taskManager;
        }

        @Override
        public int getProgress() {
            if (this.callable instanceof ProgressingCallable) {
                ProgressingCallable pc = (ProgressingCallable)this.callable;
                return pc.getProgress();
            }
            return -1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TaskImpl)) {
                return false;
            }
            TaskImpl task = (TaskImpl)o;
            if (this.id != task.id) {
                return false;
            }
            return this.taskManager == task.getTaskManager();
        }

        public int hashCode() {
            return (int)this.id;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Task[id=").append(this.id).append(", name=\"").append(this.name).append("\"");
            result.append(", progress=");
            int progress = this.getProgress();
            if (progress < 0) {
                result.append("unknown");
            } else {
                result.append(progress);
            }
            result.append("]");
            return result.toString();
        }
    }

    private class ProgressChangeListener
    implements PropertyChangeListener {
        private ProgressChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            Object newValue = evt.getNewValue();
            if (source instanceof ProgressingCallable && newValue instanceof Integer && "progress".equals(evt.getPropertyName())) {
                int progress = (Integer)newValue;
                int callableIdentity = System.identityHashCode(source);
                ReentrantReadWriteLock.WriteLock lock = TaskManager.this.tasksLock.writeLock();
                lock.lock();
                try {
                    Task task = (Task)TaskManager.this.callableTasks.get(callableIdentity);
                    if (task != null) {
                        TaskManager.this.internalProgressChanges.add(new ProgressChange(task, progress));
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultListenerFireRunnable
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(TaskManager.class);
        private List<Task<T>> createdTasks;
        private List<Task<T>> done;
        private List<TaskListener<T>> clonedListeners;
        private List<ProgressChange<T>> progressChanges;

        public ResultListenerFireRunnable(List<Task<T>> createdTasks, List<Task<T>> done, List<ProgressChange<T>> progressChanges) {
            this.createdTasks = createdTasks;
            this.done = done;
            this.progressChanges = progressChanges;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ReentrantReadWriteLock.ReadLock lock = TaskManager.this.taskListenersLock.readLock();
            lock.lock();
            try {
                this.clonedListeners = new ArrayList(TaskManager.this.taskListeners);
            }
            finally {
                lock.unlock();
            }
            if (this.createdTasks != null) {
                for (Task task : this.createdTasks) {
                    this.fireCreatedEvent(task);
                }
            }
            if (this.progressChanges != null) {
                for (ProgressChange progressChange : this.progressChanges) {
                    this.fireProgressEvent(progressChange.getTask(), progressChange.getProgress());
                }
            }
            if (this.done != null) {
                for (Task task : this.done) {
                    Future future;
                    Callable callable = task.getCallable();
                    if (callable instanceof ProgressingCallable) {
                        ProgressingCallable pc = (ProgressingCallable)callable;
                        pc.removePropertyChangeListener(TaskManager.this.progressChangeListener);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Removed progress change listener from callable.");
                        }
                    }
                    if ((future = task.getFuture()).isCancelled()) {
                        this.fireCanceledEvent(task);
                        continue;
                    }
                    try {
                        this.fireFinishedEvent(task, future.get());
                    }
                    catch (InterruptedException e) {
                        if (!this.logger.isInfoEnabled()) continue;
                        this.logger.info("Interrupted...", (Throwable)e);
                    }
                    catch (ExecutionException e) {
                        this.fireExceptionEvent(task, e);
                    }
                }
            }
        }

        private void fireCreatedEvent(Task<T> task) {
            for (TaskListener listener : this.clonedListeners) {
                try {
                    listener.taskCreated(task);
                }
                catch (Throwable t) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("TaskListener " + listener + " threw an exception while progressUpdated was called!", t);
                    }
                    IOUtilities.interruptIfNecessary((Throwable)t);
                }
            }
        }

        private void fireProgressEvent(Task<T> task, int progress) {
            for (TaskListener listener : this.clonedListeners) {
                try {
                    listener.progressUpdated(task, progress);
                }
                catch (Throwable t) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("TaskListener " + listener + " threw an exception while progressUpdated was called!", t);
                    }
                    IOUtilities.interruptIfNecessary((Throwable)t);
                }
            }
        }

        private void fireExceptionEvent(Task<T> task, ExecutionException exception) {
            for (TaskListener listener : this.clonedListeners) {
                try {
                    listener.executionFailed(task, exception);
                }
                catch (Throwable t) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("TaskListener " + listener + " threw an exception while executionFailed was called!", t);
                    }
                    IOUtilities.interruptIfNecessary((Throwable)t);
                }
            }
        }

        private void fireFinishedEvent(Task<T> task, T result) {
            for (TaskListener listener : this.clonedListeners) {
                try {
                    listener.executionFinished(task, result);
                }
                catch (Throwable t) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("TaskListener " + listener + " threw an exception while executionFinished was called!", t);
                    }
                    IOUtilities.interruptIfNecessary((Throwable)t);
                }
            }
        }

        private void fireCanceledEvent(Task<T> task) {
            for (TaskListener listener : this.clonedListeners) {
                try {
                    listener.executionCanceled(task);
                }
                catch (Throwable t) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("TaskListener " + listener + " threw an exception while executionCanceled was called!", t);
                    }
                    IOUtilities.interruptIfNecessary((Throwable)t);
                }
            }
        }
    }

    private class TaskResultPoller
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(TaskResultPoller.class);
        private static final long POLL_INTERVAL = 200L;

        private TaskResultPoller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    ArrayList progressChanges = null;
                    ArrayList<Task> doneTasks = null;
                    ArrayList createdTasks = null;
                    ReentrantReadWriteLock.WriteLock lock = TaskManager.this.tasksLock.writeLock();
                    lock.lock();
                    try {
                        if (TaskManager.this.internalCreatedTasks.size() > 0) {
                            createdTasks = new ArrayList(TaskManager.this.internalCreatedTasks);
                            TaskManager.this.internalCreatedTasks.clear();
                        }
                        if (TaskManager.this.internalProgressChanges.size() > 0) {
                            progressChanges = new ArrayList(TaskManager.this.internalProgressChanges);
                            TaskManager.this.internalProgressChanges.clear();
                        }
                        for (Map.Entry entry : TaskManager.this.tasks.entrySet()) {
                            Task task = (Task)entry.getValue();
                            if (!task.getFuture().isDone()) continue;
                            if (doneTasks == null) {
                                doneTasks = new ArrayList<Task>();
                            }
                            doneTasks.add(task);
                        }
                        if (doneTasks != null) {
                            for (Task task : doneTasks) {
                                int callableIdentity = System.identityHashCode(task.getCallable());
                                TaskManager.this.tasks.remove(task.getId());
                                TaskManager.this.callableTasks.remove(callableIdentity);
                            }
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                    if (createdTasks != null || doneTasks != null || progressChanges != null) {
                        ResultListenerFireRunnable runnable = new ResultListenerFireRunnable(createdTasks, doneTasks, progressChanges);
                        if (TaskManager.this.usingEventQueue) {
                            EventQueue.invokeLater(runnable);
                        } else {
                            runnable.run();
                        }
                    }
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException e) {
                block16: {
                    if (!this.logger.isDebugEnabled()) break block16;
                    this.logger.debug("Interrupted...", (Throwable)e);
                }
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProgressChange<V> {
        private final int progress;
        private final Task<V> task;

        public ProgressChange(Task<V> task, int progress) {
            this.progress = progress;
            this.task = task;
        }

        public int getProgress() {
            return this.progress;
        }

        public Task<V> getTask() {
            return this.task;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        INITIALIZED,
        RUNNING,
        STOPPED;

    }
}

