/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.jbehave.junit.monitoring;

import java.io.PrintStream;

public class Logger {
    public static final String PROP_JJM_LOGLEVEL = "jjm.loglevel";
    private volatile LogLevel logLevel;
    PrintStream logStream = System.out;

    public void info(String message, Object ... params) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.printMessage(LogLevel.INFO, message, params);
    }

    public void debug(String message, Object ... params) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.printMessage(LogLevel.DEBUG, message, params);
    }

    boolean isInfoEnabled() {
        return this.isLevelEnabled(LogLevel.INFO);
    }

    boolean isLevelEnabled(LogLevel level) {
        return this.getLogLevel().ordinal() >= level.ordinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogLevel getLogLevel() {
        if (this.logLevel != null) {
            return this.logLevel;
        }
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (this.logLevel == null) {
                String configuredLevel = System.getProperty(PROP_JJM_LOGLEVEL);
                if (configuredLevel == null || "".equals(configuredLevel.trim())) {
                    this.logLevel = LogLevel.NONE;
                } else {
                    configuredLevel = configuredLevel.trim();
                    try {
                        this.logLevel = LogLevel.valueOf(configuredLevel.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        this.logLevel = LogLevel.NONE;
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.logLevel;
        }
    }

    boolean isDebugEnabled() {
        return this.isLevelEnabled(LogLevel.DEBUG);
    }

    private void printMessage(LogLevel level, String message, Object ... params) {
        String format = message.replace("{}", "%s");
        Object[] strings = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            strings[i] = params[i] == null ? "null" : params[i].toString();
        }
        this.logStream.println((Object)((Object)level) + ": " + String.format(format, strings));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LogLevel {
        NONE,
        ERROR,
        WARN,
        INFO,
        DEBUG;

    }
}

