/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxws;

import com.webcohesion.enunciate.api.InterfaceDescriptionFile;
import com.webcohesion.enunciate.javac.TypeElementComparator;
import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.model.SchemaInfo;
import com.webcohesion.enunciate.modules.jaxws.model.EndpointInterface;
import com.webcohesion.enunciate.modules.jaxws.model.WebFault;
import com.webcohesion.enunciate.modules.jaxws.model.WebMessage;
import com.webcohesion.enunciate.modules.jaxws.model.WebMethod;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class WsdlInfo {
    private String id;
    private String targetNamespace;
    private String filename;
    private boolean inlineSchema;
    private final Set<EndpointInterface> endpointInterfaces = new TreeSet<EndpointInterface>((Comparator<EndpointInterface>)new TypeElementComparator());
    private final EnunciateJaxbContext jaxbContext;
    private InterfaceDescriptionFile wsdlFile;

    public WsdlInfo(EnunciateJaxbContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EnunciateJaxbContext getContext() {
        return this.jaxbContext;
    }

    public InterfaceDescriptionFile getWsdlFile() {
        return this.wsdlFile;
    }

    public void setWsdlFile(InterfaceDescriptionFile wsdlFile) {
        this.wsdlFile = wsdlFile;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean isInlineSchema() {
        return this.inlineSchema;
    }

    public void setInlineSchema(boolean inlineSchema) {
        this.inlineSchema = inlineSchema;
    }

    public List<WebMessage> getWebMessages() {
        ArrayList<WebMessage> messages = new ArrayList<WebMessage>();
        HashSet<String> foundFaults = new HashSet<String>();
        for (EndpointInterface ei : this.getEndpointInterfaces()) {
            List<WebMethod> webMethods = ei.getWebMethods();
            for (WebMethod method : webMethods) {
                for (WebMessage webMessage : method.getMessages()) {
                    if (webMessage.isFault() && !foundFaults.add(((WebFault)webMessage).getQualifiedName().toString())) continue;
                    messages.add(webMessage);
                }
            }
        }
        return messages;
    }

    public Set<EndpointInterface> getEndpointInterfaces() {
        return this.endpointInterfaces;
    }

    public Set<String> getImportedNamespaces() {
        SchemaInfo associatedSchema;
        Set<EndpointInterface> endpointInterfaces = this.getEndpointInterfaces();
        if (endpointInterfaces == null || endpointInterfaces.size() == 0) {
            throw new IllegalStateException("WSDL for " + this.getTargetNamespace() + " has no endpoint interfaces!");
        }
        HashSet<String> importedNamespaces = new HashSet<String>();
        importedNamespaces.add("http://schemas.xmlsoap.org/wsdl/");
        importedNamespaces.add("http://schemas.xmlsoap.org/wsdl/http/");
        importedNamespaces.add("http://schemas.xmlsoap.org/wsdl/mime/");
        importedNamespaces.add("http://schemas.xmlsoap.org/wsdl/soap/");
        importedNamespaces.add("http://schemas.xmlsoap.org/wsdl/soap12/");
        importedNamespaces.add("http://schemas.xmlsoap.org/soap/encoding/");
        importedNamespaces.add("http://www.w3.org/2001/XMLSchema");
        for (EndpointInterface endpointInterface : endpointInterfaces) {
            importedNamespaces.addAll(endpointInterface.getReferencedNamespaces());
        }
        if (this.isInlineSchema() && (associatedSchema = this.getAssociatedSchema()) != null) {
            importedNamespaces.addAll(associatedSchema.getReferencedNamespaces());
        }
        return importedNamespaces;
    }

    public List<SchemaInfo> getImportedSchemas() {
        Set<String> importedNamespaces = this.getImportedNamespaces();
        importedNamespaces.remove(this.getTargetNamespace());
        ArrayList<SchemaInfo> schemas = new ArrayList<SchemaInfo>();
        for (String ns : importedNamespaces) {
            SchemaInfo schema = this.lookupSchema(ns);
            if (schema == null) continue;
            schemas.add(schema);
        }
        return schemas;
    }

    public SchemaInfo getAssociatedSchema() {
        return this.lookupSchema(this.getTargetNamespace());
    }

    protected SchemaInfo lookupSchema(String namespace) {
        if ("".equals(namespace)) {
            namespace = null;
        }
        return (SchemaInfo)this.jaxbContext.getSchemas().get(namespace);
    }
}

