/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson1.model;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.introspect.VisibilityChecker;

public class AccessorVisibilityChecker {
    private final Map<JsonMethod, JsonAutoDetect.Visibility> minLevels;
    public static final JsonAutoDetect DEFAULT_VISIBILITY = VisibilityChecker.Std.class.getAnnotation(JsonAutoDetect.class);
    public static final AccessorVisibilityChecker DEFAULT_CHECKER = new AccessorVisibilityChecker(DEFAULT_VISIBILITY);

    private AccessorVisibilityChecker(Map<JsonMethod, JsonAutoDetect.Visibility> minLevels) {
        this.minLevels = minLevels;
    }

    public AccessorVisibilityChecker(JsonAutoDetect annotation) {
        this(AccessorVisibilityChecker.createMap(annotation.getterVisibility(), annotation.isGetterVisibility(), annotation.setterVisibility(), annotation.creatorVisibility(), annotation.fieldVisibility()));
    }

    public AccessorVisibilityChecker with(JsonAutoDetect annotation) {
        return new AccessorVisibilityChecker(AccessorVisibilityChecker.createMap((annotation.getterVisibility() == JsonAutoDetect.Visibility.DEFAULT ? DEFAULT_VISIBILITY : annotation).getterVisibility(), (annotation.isGetterVisibility() == JsonAutoDetect.Visibility.DEFAULT ? DEFAULT_VISIBILITY : annotation).isGetterVisibility(), (annotation.setterVisibility() == JsonAutoDetect.Visibility.DEFAULT ? DEFAULT_VISIBILITY : annotation).setterVisibility(), (annotation.creatorVisibility() == JsonAutoDetect.Visibility.DEFAULT ? DEFAULT_VISIBILITY : annotation).creatorVisibility(), (annotation.fieldVisibility() == JsonAutoDetect.Visibility.DEFAULT ? DEFAULT_VISIBILITY : annotation).fieldVisibility()));
    }

    public AccessorVisibilityChecker withVisibility(JsonMethod method, JsonAutoDetect.Visibility level) {
        return new AccessorVisibilityChecker(AccessorVisibilityChecker.changeMap(this.minLevels, method, level));
    }

    public JsonAutoDetect.Visibility getVisibility(JsonMethod method) {
        return this.minLevels.get(method);
    }

    private static Map<JsonMethod, JsonAutoDetect.Visibility> createMap(JsonAutoDetect.Visibility getterLevel, JsonAutoDetect.Visibility isGetterLevel, JsonAutoDetect.Visibility setterLevel, JsonAutoDetect.Visibility creatorLevel, JsonAutoDetect.Visibility fieldLevel) {
        EnumMap<JsonMethod, JsonAutoDetect.Visibility> levels = new EnumMap<JsonMethod, JsonAutoDetect.Visibility>(JsonMethod.class);
        levels.put(JsonMethod.GETTER, getterLevel);
        levels.put(JsonMethod.IS_GETTER, isGetterLevel);
        levels.put(JsonMethod.SETTER, setterLevel);
        levels.put(JsonMethod.CREATOR, creatorLevel);
        levels.put(JsonMethod.FIELD, fieldLevel);
        return Collections.unmodifiableMap(levels);
    }

    private static Map<JsonMethod, JsonAutoDetect.Visibility> changeMap(Map<JsonMethod, JsonAutoDetect.Visibility> original, JsonMethod method, JsonAutoDetect.Visibility level) {
        EnumMap<JsonMethod, JsonAutoDetect.Visibility> levels = new EnumMap<JsonMethod, JsonAutoDetect.Visibility>(JsonMethod.class);
        if (method == JsonMethod.ALL) {
            return AccessorVisibilityChecker.createMap(level, level, level, level, level);
        }
        levels.putAll(original);
        levels.put(method, level);
        return Collections.unmodifiableMap(levels);
    }
}

