/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;

public abstract class BasicRenderer<SOURCE, TARGET>
extends ComponentRenderer<Component, SOURCE> {
    private final ValueProvider<SOURCE, TARGET> valueProvider;

    protected BasicRenderer(ValueProvider<SOURCE, TARGET> valueProvider) {
        super((SerializableSupplier)null);
        if (valueProvider == null) {
            throw new IllegalArgumentException("valueProvider may not be null");
        }
        this.valueProvider = valueProvider;
        this.withProperty("label", (ValueProvider & Serializable)item -> this.getFormattedValue(valueProvider.apply(item)));
    }

    @Override
    protected String getTemplateExpression() {
        return "${item.label}";
    }

    protected ValueProvider<SOURCE, TARGET> getValueProvider() {
        return this.valueProvider;
    }

    @Override
    Rendering<SOURCE> configureRendering(Rendering<SOURCE> rendering, DataKeyMapper<SOURCE> keyMapper) {
        return rendering;
    }

    @Override
    public Component createComponent(SOURCE item) {
        Element span = ElementFactory.createSpan((String)this.getFormattedValue(this.valueProvider.apply(item)));
        return ComponentUtil.componentFromElement((Element)span, Span.class, (boolean)true);
    }

    protected String getFormattedValue(TARGET object) {
        return String.valueOf(object);
    }
}

