/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.combobox;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.combobox.ComboBoxBase;
import com.vaadin.flow.component.combobox.ComboBoxDataCommunicator;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import com.vaadin.flow.component.combobox.dataview.ComboBoxDataView;
import com.vaadin.flow.component.combobox.dataview.ComboBoxLazyDataView;
import com.vaadin.flow.component.combobox.dataview.ComboBoxListDataView;
import com.vaadin.flow.data.provider.ArrayUpdater;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.DataProviderWrapper;
import com.vaadin.flow.data.provider.DataViewUtils;
import com.vaadin.flow.data.provider.HasDataView;
import com.vaadin.flow.data.provider.HasLazyDataView;
import com.vaadin.flow.data.provider.HasListDataView;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.ItemCountChangeEvent;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.dom.PropertyChangeEvent;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import tools.jackson.databind.JsonNode;

class ComboBoxDataController<TItem>
implements HasDataView<TItem, String, ComboBoxDataView<TItem>>,
HasListDataView<TItem, ComboBoxListDataView<TItem>>,
HasLazyDataView<TItem, String, ComboBoxLazyDataView<TItem>> {
    private final ArrayUpdater arrayUpdater = new ArrayUpdater(){

        public ArrayUpdater.Update startUpdate(int sizeChange) {
            return new UpdateQueue(sizeChange);
        }

        public void initialize() {
        }
    };
    private final ComboBoxBase<?, TItem, ?> comboBox;
    private final SerializableSupplier<Locale> localeSupplier;
    private ComboBoxDataCommunicator<TItem> dataCommunicator;
    private final CompositeDataGenerator<TItem> dataGenerator = new CompositeDataGenerator();
    private UserProvidedFilter userProvidedFilter = UserProvidedFilter.UNDECIDED;
    private boolean shouldForceServerSideFiltering = false;
    private String lastFilter;
    private SerializableConsumer<String> filterSlot = (SerializableConsumer & Serializable)filter -> {};
    private Registration lazyOpenRegistration;
    private Registration clearFilterOnCloseRegistration;
    private Registration dataProviderListener = null;

    ComboBoxDataController(ComboBoxBase<?, TItem, ?> comboBox, SerializableSupplier<Locale> localeSupplier) {
        this.comboBox = comboBox;
        this.localeSupplier = localeSupplier;
        ComponentUtil.addListener(comboBox, ItemCountChangeEvent.class, (ComponentEventListener & Serializable)e -> this.updateClientSideFiltering());
    }

    ComboBoxDataCommunicator<TItem> getDataCommunicator() {
        return this.dataCommunicator;
    }

    DataProvider<TItem, ?> getDataProvider() {
        if (this.dataCommunicator != null) {
            return this.dataCommunicator.getDataProvider();
        }
        return null;
    }

    CompositeDataGenerator<TItem> getDataGenerator() {
        return this.dataGenerator;
    }

    void setPageSize(int pageSize) {
        if (this.dataCommunicator != null) {
            this.dataCommunicator.setPageSize(pageSize);
        }
        this.reset();
        this.updateClientSideFiltering();
    }

    void onAttach() {
        DataProvider<TItem, ?> dataProvider = this.getDataProvider();
        if (dataProvider != null) {
            this.setupDataProviderListener(dataProvider);
        }
        this.clearFilterOnCloseRegistration = this.comboBox.getElement().addPropertyChangeListener("opened", this::clearFilterOnClose);
        this.reset();
    }

    void onDetach() {
        if (this.dataProviderListener != null) {
            this.dataProviderListener.remove();
            this.dataProviderListener = null;
        }
        if (this.clearFilterOnCloseRegistration != null) {
            this.clearFilterOnCloseRegistration.remove();
            this.clearFilterOnCloseRegistration = null;
        }
    }

    void reset() {
        this.lastFilter = null;
        if (this.dataCommunicator != null) {
            this.dataCommunicator.setViewportRange(0, 0);
            this.dataCommunicator.reset();
        }
        this.comboBox.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> ui.getPage().executeJs("if($0.$connector) $0.$connector.reset();", new Object[]{this.comboBox.getElement()}));
    }

    void confirmUpdate(int id) {
        this.dataCommunicator.confirmUpdate(id);
    }

    void setViewportRange(int start, int length, String filter) {
        if (this.lastFilter == null) {
            this.dataCommunicator.reset();
        }
        this.dataCommunicator.setViewportRange(start, length);
        this.filterSlot.accept((Object)filter);
    }

    void resetDataCommunicator() {
        this.dataCommunicator.reset();
    }

    public ComboBoxListDataView<TItem> getListDataView() {
        return new ComboBoxListDataView<TItem>(this.getDataCommunicator(), this.comboBox, this::onInMemoryFilterOrSortingChange);
    }

    public ComboBoxListDataView<TItem> setItems(ComboBox.ItemFilter<TItem> itemFilter, Collection<TItem> items) {
        ListDataProvider listDataProvider = DataProvider.ofCollection(items);
        this.setDataProvider(itemFilter, listDataProvider);
        return this.getListDataView();
    }

    @SafeVarargs
    public final ComboBoxListDataView<TItem> setItems(ComboBox.ItemFilter<TItem> itemFilter, TItem ... items) {
        return this.setItems(itemFilter, (Collection<TItem>)new ArrayList<TItem>(Arrays.asList(items)));
    }

    public ComboBoxListDataView<TItem> setItems(ComboBox.ItemFilter<TItem> itemFilter, ListDataProvider<TItem> listDataProvider) {
        this.setDataProvider(itemFilter, listDataProvider);
        return this.getListDataView();
    }

    public ComboBoxListDataView<TItem> setItems(ListDataProvider<TItem> dataProvider) {
        this.setDataProvider(dataProvider);
        return this.getListDataView();
    }

    public ComboBoxLazyDataView<TItem> getLazyDataView() {
        return new ComboBoxLazyDataView<TItem>(this.getDataCommunicator(), (Component)this.comboBox);
    }

    public <TComponent> ComboBoxLazyDataView<TItem> setItemsWithFilterConverter(CallbackDataProvider.FetchCallback<TItem, TComponent> fetchCallback, SerializableFunction<String, TComponent> filterConverter) {
        Objects.requireNonNull(fetchCallback, "Fetch callback cannot be null");
        ComboBoxLazyDataView<TItem> lazyDataView = this.setItemsWithFilterConverter(fetchCallback, (CallbackDataProvider.CountCallback & Serializable)query -> {
            throw new IllegalStateException("Trying to use exact size with a lazy loading component without either providing a count callback for the component to fetch the count of the items or a data provider that implements the size query. Provide the callback for fetching item count with%ncomboBox.getLazyDataView().withDefinedSize(CallbackDataProvider.CountCallback);%nor switch to undefined size with%ncomboBox.getLazyDataView().withUndefinedSize()");
        }, filterConverter);
        lazyDataView.setItemCountUnknown();
        return lazyDataView;
    }

    public <TComponent> ComboBoxLazyDataView<TItem> setItemsWithFilterConverter(CallbackDataProvider.FetchCallback<TItem, TComponent> fetchCallback, CallbackDataProvider.CountCallback<TItem, TComponent> countCallback, SerializableFunction<String, TComponent> filterConverter) {
        this.setDataProvider((DataProvider<TItem, TComponent>)DataProvider.fromFilteringCallbacks(fetchCallback, countCallback), filterConverter);
        return this.getLazyDataView();
    }

    public ComboBoxLazyDataView<TItem> setItems(BackEndDataProvider<TItem, String> dataProvider) {
        this.setDataProvider((DataProvider<TItem, String>)dataProvider);
        return this.getLazyDataView();
    }

    public ComboBoxDataView<TItem> getGenericDataView() {
        return new ComboBoxDataView<TItem>(this.dataCommunicator, this.comboBox);
    }

    public ComboBoxDataView<TItem> setItems(DataProvider<TItem, String> dataProvider) {
        this.setDataProvider(dataProvider);
        return this.getGenericDataView();
    }

    public ComboBoxDataView<TItem> setItems(InMemoryDataProvider<TItem> dataProvider) {
        throw new UnsupportedOperationException();
    }

    public ComboBoxDataView<TItem> setItems(InMemoryDataProvider<TItem> inMemoryDataProvider, SerializableFunction<String, SerializablePredicate<TItem>> filterConverter) {
        Objects.requireNonNull(filterConverter, "FilterConverter cannot be null");
        DataProviderWrapper convertedDataProvider = new DataProviderWrapper<TItem, String, SerializablePredicate<TItem>>((DataProvider)inMemoryDataProvider, (InMemoryDataProvider)inMemoryDataProvider, (SerializableFunction)filterConverter){
            final /* synthetic */ InMemoryDataProvider val$inMemoryDataProvider;
            final /* synthetic */ SerializableFunction val$filterConverter;
            {
                this.val$inMemoryDataProvider = inMemoryDataProvider;
                this.val$filterConverter = serializableFunction;
                super(arg0);
            }

            protected SerializablePredicate<TItem> getFilter(Query<TItem, String> query) {
                Optional componentInMemoryFilter = DataViewUtils.getComponentFilter(ComboBoxDataController.this.comboBox);
                return Optional.ofNullable(this.val$inMemoryDataProvider.getFilter()).orElse((SerializablePredicate & Serializable)item -> true).and(item -> ((SerializablePredicate)this.val$filterConverter.apply((Object)query.getFilter().orElse(""))).test(item)).and((Predicate)componentInMemoryFilter.orElse((SerializablePredicate & Serializable)item -> true));
            }
        };
        if (this.userProvidedFilter == UserProvidedFilter.UNDECIDED) {
            this.userProvidedFilter = UserProvidedFilter.NO;
        }
        return this.setItems((DataProvider<TItem, String>)convertedDataProvider);
    }

    public void setDataProvider(DataProvider<TItem, String> dataProvider) {
        this.setDataProvider(dataProvider, SerializableFunction.identity());
    }

    public void setDataProvider(ListDataProvider<TItem> listDataProvider) {
        if (this.userProvidedFilter == UserProvidedFilter.UNDECIDED) {
            this.userProvidedFilter = UserProvidedFilter.NO;
        }
        ComboBox.ItemFilter<Object> & Serializable defaultItemFilter = (ComboBox.ItemFilter<Object> & Serializable)(item, filterText) -> this.comboBox.getItemLabelGenerator().apply(item).toLowerCase((Locale)this.localeSupplier.get()).contains(filterText.toLowerCase((Locale)this.localeSupplier.get()));
        this.setDataProvider(defaultItemFilter, listDataProvider);
    }

    public void setDataProvider(ComboBox.FetchItemsCallback<TItem> fetchItems, SerializableFunction<String, Integer> sizeCallback) {
        Objects.requireNonNull(fetchItems, "Fetch callback cannot be null");
        Objects.requireNonNull(sizeCallback, "Size callback cannot be null");
        this.userProvidedFilter = UserProvidedFilter.YES;
        this.setDataProvider((DataProvider<TItem, String>)new CallbackDataProvider((CallbackDataProvider.FetchCallback & Serializable)query -> fetchItems.fetchItems(query.getFilter().orElse(""), query.getOffset(), query.getLimit()), (CallbackDataProvider.CountCallback & Serializable)query -> (Integer)sizeCallback.apply((Object)query.getFilter().orElse(""))));
    }

    public void setDataProvider(ComboBox.ItemFilter<TItem> itemFilter, ListDataProvider<TItem> listDataProvider) {
        Objects.requireNonNull(listDataProvider, "List data provider cannot be null");
        this.setDataProvider((DataProvider)listDataProvider, (SerializableFunction)(SerializableFunction & Serializable)filterText -> {
            Optional componentInMemoryFilter = DataViewUtils.getComponentFilter(this.comboBox);
            SerializablePredicate componentInMemoryFilterOrAlwaysPass = componentInMemoryFilter.orElse((SerializablePredicate & Serializable)ignore -> true);
            return (SerializablePredicate & Serializable)item -> itemFilter.test((Object)item, (String)filterText) && componentInMemoryFilterOrAlwaysPass.test(item);
        });
    }

    public <TComponent> void setDataProvider(DataProvider<TItem, TComponent> dataProvider, SerializableFunction<String, TComponent> filterConverter) {
        boolean enableFetch;
        Objects.requireNonNull(dataProvider, "The data provider can not be null");
        Objects.requireNonNull(filterConverter, "filterConverter cannot be null");
        if (this.userProvidedFilter == UserProvidedFilter.UNDECIDED) {
            this.userProvidedFilter = UserProvidedFilter.YES;
        }
        boolean bl = enableFetch = dataProvider.isInMemory() && !DataCommunicator.EmptyDataProvider.class.isAssignableFrom(dataProvider.getClass());
        if (this.dataCommunicator == null) {
            this.dataCommunicator = new ComboBoxDataCommunicator<TItem>(this.comboBox, (DataGenerator)this.dataGenerator, this.arrayUpdater, (SerializableConsumer & Serializable)data -> this.comboBox.getElement().callJsFunction("$connector.updateData", new Object[]{data}), this.comboBox.getElement().getNode(), enableFetch){

                public void reset() {
                    super.reset();
                    if (ComboBoxDataController.this.comboBox instanceof MultiSelectComboBox) {
                        ComboBoxDataController.this.comboBox.refreshValue();
                    }
                }
            };
            this.dataCommunicator.setPageSize(this.comboBox.getPageSize());
        } else {
            this.dataCommunicator.setFetchEnabled(enableFetch);
        }
        this.comboBox.getRenderManager().scheduleRender();
        this.comboBox.setValue(null);
        SerializableFunction & Serializable convertOrNull = (SerializableFunction & Serializable)filterText -> {
            if (filterText == null) {
                return null;
            }
            return filterConverter.apply(filterText);
        };
        SerializableConsumer providerFilterSlot = this.dataCommunicator.setDataProvider(dataProvider, convertOrNull.apply((Object)this.comboBox.getFilter()), false);
        this.filterSlot = (SerializableConsumer & Serializable)filter -> {
            if (!Objects.equals(filter, this.lastFilter)) {
                DataCommunicator.Filter objectFilter = new DataCommunicator.Filter(convertOrNull.apply(filter), filter.isEmpty());
                providerFilterSlot.accept((Object)objectFilter);
                this.lastFilter = filter;
            }
        };
        this.shouldForceServerSideFiltering = this.userProvidedFilter == UserProvidedFilter.YES;
        this.setupDataProviderListener(dataProvider);
        this.reset();
        this.updateClientSideFiltering();
        this.userProvidedFilter = UserProvidedFilter.UNDECIDED;
        if (this.lazyOpenRegistration == null && !enableFetch) {
            this.lazyOpenRegistration = this.comboBox.getElement().addPropertyChangeListener("opened", this::executeRegistration);
        }
    }

    private void updateClientSideFiltering() {
        if (this.dataCommunicator != null) {
            this.setClientSideFilter(!this.shouldForceServerSideFiltering && this.dataCommunicator.getItemCount() <= this.comboBox.getPageSize());
        }
    }

    private void setClientSideFilter(boolean clientSideFilter) {
        this.comboBox.getElement().setProperty("_clientSideFilter", clientSideFilter);
    }

    private void clearFilterOnClose(PropertyChangeEvent event) {
        if (Boolean.FALSE.equals(event.getValue()) && this.lastFilter != null && !this.lastFilter.isEmpty()) {
            this.clearClientSideFilterAndUpdateInMemoryFilter();
        }
    }

    private void executeRegistration(PropertyChangeEvent event) {
        if (Boolean.TRUE.equals(event.getValue())) {
            this.removeLazyOpenRegistration();
            this.dataCommunicator.setFetchEnabled(true);
            if (!this.comboBox.isAutoOpen()) {
                this.setViewportRange(0, this.comboBox.getPageSize(), this.comboBox.getFilter());
            }
        }
    }

    private void removeLazyOpenRegistration() {
        if (this.lazyOpenRegistration != null) {
            this.lazyOpenRegistration.remove();
            this.lazyOpenRegistration = null;
        }
    }

    private void onInMemoryFilterOrSortingChange(SerializablePredicate<TItem> filter, SerializableComparator<TItem> sortComparator) {
        this.dataCommunicator.setInMemorySorting(sortComparator);
        this.clearClientSideFilterAndUpdateInMemoryFilter();
    }

    private void clearClientSideFilterAndUpdateInMemoryFilter() {
        this.lastFilter = null;
        this.filterSlot.accept((Object)"");
        this.reset();
    }

    private <C> void setupDataProviderListener(DataProvider<TItem, C> dataProvider) {
        if (this.dataProviderListener != null) {
            this.dataProviderListener.remove();
        }
        this.dataProviderListener = dataProvider.addDataProviderListener((DataProviderListener & Serializable)e -> {
            if (e instanceof DataChangeEvent.DataRefreshEvent) {
                this.dataCommunicator.refresh(((DataChangeEvent.DataRefreshEvent)e).getItem());
            } else {
                this.reset();
            }
        });
    }

    private static enum UserProvidedFilter {
        UNDECIDED,
        YES,
        NO;

    }

    private final class UpdateQueue
    implements ArrayUpdater.Update {
        private final transient List<Runnable> queue = new ArrayList<Runnable>();

        private UpdateQueue(int size) {
            this.enqueue("$connector.updateSize", Integer.valueOf(size));
            ComboBoxDataController.this.comboBox.getElement().setProperty("size", (double)size);
        }

        public void set(int start, List<JsonNode> items) {
            this.enqueue("$connector.set", new Serializable[]{Integer.valueOf(start), (Serializable)items.stream().collect(JacksonUtils.asArray()), ComboBoxDataController.this.lastFilter});
        }

        public void clear(int start, int length) {
            this.enqueue("$connector.clear", Integer.valueOf(start), Integer.valueOf(length));
        }

        public void commit(int updateId) {
            this.enqueue("$connector.confirm", new Serializable[]{Integer.valueOf(updateId), ComboBoxDataController.this.lastFilter});
            this.queue.forEach(Runnable::run);
            this.queue.clear();
        }

        private void enqueue(String name, Serializable ... arguments) {
            this.queue.add(() -> ComboBoxDataController.this.comboBox.getElement().callJsFunction(name, arguments));
        }
    }
}

