/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets.draft76;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.http.MimeHeaders;
import com.sun.grizzly.util.net.URL;
import com.sun.grizzly.websockets.HandShake;
import com.sun.grizzly.websockets.HandshakeException;
import com.sun.grizzly.websockets.NetworkHandler;
import com.sun.grizzly.websockets.WebSocketApplication;
import com.sun.grizzly.websockets.draft76.SecKey;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandShake76
extends HandShake {
    public static final String SEC_WS_KEY1_HEADER = "Sec-WebSocket-Key1";
    public static final String SEC_WS_KEY2_HEADER = "Sec-WebSocket-Key2";
    public static final String SERVER_SEC_WS_ORIGIN_HEADER = "Sec-WebSocket-Origin";
    public static final String SERVER_SEC_WS_LOCATION_HEADER = "Sec-WebSocket-Location";
    private final SecKey key1;
    private final SecKey key2;
    private final byte[] key3;
    private byte[] serverSecKey;
    private static final Random random = new Random();
    private final NetworkHandler handler;

    public HandShake76(NetworkHandler handler, URL url) {
        super(url);
        if (this.isSecure() && this.getPort() != 443 || !this.isSecure() && this.getPort() != 80) {
            this.setServerHostName(this.getServerHostName() + ":" + this.getPort());
        }
        this.handler = handler;
        this.key1 = SecKey.generateSecKey();
        this.key2 = SecKey.generateSecKey();
        this.key3 = new byte[8];
        random.nextBytes(this.key3);
    }

    public HandShake76(NetworkHandler handler, Request request) {
        super(request);
        this.handler = handler;
        MimeHeaders headers = request.getMimeHeaders();
        this.key1 = SecKey.parse(headers.getHeader(SEC_WS_KEY1_HEADER));
        this.key2 = SecKey.parse(headers.getHeader(SEC_WS_KEY2_HEADER));
        this.key3 = handler.get(8);
        this.serverSecKey = this.key3 == null ? null : SecKey.generateServerKey(this.key1, this.key2, this.key3);
    }

    @Override
    public void initiate(NetworkHandler handler) {
        super.initiate(handler);
        handler.write(String.format("%s: %s\r\n", "Origin", this.getOrigin()).getBytes());
        handler.write(String.format("%s: %s\r\n", SEC_WS_KEY1_HEADER, this.key1.getSecKey()).getBytes());
        handler.write(String.format("%s: %s\r\n", SEC_WS_KEY2_HEADER, this.key2.getSecKey()).getBytes());
        handler.write("\r\n".getBytes());
        handler.write(this.key3);
    }

    @Override
    public void validateServerResponse(Map<String, String> headers) {
        byte[] serverKey;
        super.validateServerResponse(headers);
        String serverLocation = headers.get(SERVER_SEC_WS_LOCATION_HEADER);
        if (!this.getLocation().equals(serverLocation)) {
            throw new HandshakeException(String.format("Location field from server doesn't match: client '%s' vs. server '%s'", this.getLocation(), serverLocation));
        }
        byte[] clientKey = SecKey.generateServerKey(this.key1, this.key2, this.key3);
        if (!Arrays.equals(clientKey, serverKey = this.handler.get(16))) {
            throw new HandshakeException(String.format("Security keys do not match: client '%s' vs. server '%s'", Arrays.toString(clientKey), Arrays.toString(serverKey)));
        }
    }

    @Override
    public void respond(WebSocketApplication app, Response response) {
        super.respond(app, response);
        this.handler.write(this.serverSecKey);
    }

    @Override
    public void setHeaders(Response response) {
        response.setMessage("WebSocket Protocol Handshake");
        response.setHeader("Upgrade", "WebSocket");
        response.setHeader(SERVER_SEC_WS_LOCATION_HEADER, this.getLocation());
        response.setHeader(SERVER_SEC_WS_ORIGIN_HEADER, this.getOrigin());
    }
}

