/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.portunif;

import com.sun.grizzly.Context;
import com.sun.grizzly.portunif.PUProtocolRequest;
import com.sun.grizzly.util.OutputWriter;
import com.sun.grizzly.util.SSLOutputWriter;
import com.sun.grizzly.util.buf.Ascii;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;

public class HttpRedirector {
    private static final String NEWLINE = "\r\n";
    private static final String headers = "\r\nConnection:close\r\nCache-control: private\r\n\r\n";
    private static final ByteBuffer SC_FOUND = ByteBuffer.wrap("HTTP/1.1 302 Moved Temporarily\r\n".getBytes());

    private HttpRedirector() {
    }

    public static void redirectSSL(Context context, PUProtocolRequest protocolRequest) throws IOException {
        HttpRedirector.redirectSSL(context, protocolRequest, false);
    }

    public static void redirectSSL(Context context, PUProtocolRequest protocolRequest, boolean redirectToSecure) throws IOException {
        HttpRedirector.redirectSSL(context, protocolRequest.getSSLEngine(), protocolRequest.getByteBuffer(), protocolRequest.getSecuredOutputByteBuffer(), null, redirectToSecure);
    }

    public static void redirectSSL(Context context, SSLEngine sslEngine, ByteBuffer byteBuffer, ByteBuffer outputBB, Integer redirectPort, boolean redirectToSecure) throws IOException {
        String host = HttpRedirector.createHostString(context, byteBuffer, redirectPort);
        HttpRedirector.redirectSSL(context, sslEngine, outputBB, redirectToSecure ? "Location: https://" + host : "Location: http://" + host);
    }

    public static void redirect(Context context, PUProtocolRequest protocolRequest) throws IOException {
        HttpRedirector.redirect(context, protocolRequest, true);
    }

    public static void redirect(Context context, PUProtocolRequest protocolRequest, boolean redirectToSecure) throws IOException {
        HttpRedirector.redirect(context, protocolRequest.getByteBuffer(), null, redirectToSecure);
    }

    public static void redirect(Context context, ByteBuffer byteBuffer, Integer redirectPort, boolean redirectToSecure) throws IOException {
        String host = HttpRedirector.createHostString(context, byteBuffer, redirectPort);
        HttpRedirector.redirect(context, redirectToSecure ? "Location: https://" + host : "Location: http://" + host);
    }

    private static void redirect(Context context, String httpHeaders) throws IOException {
        SocketChannel channel = (SocketChannel)context.getSelectionKey().channel();
        ByteBuffer[] byteBuffers = new ByteBuffer[2];
        ByteBuffer statusLineBuffer = SC_FOUND.slice();
        ByteBuffer headersBuffer = ByteBuffer.wrap((httpHeaders + new String((byte[])context.getAttribute("HTTP_REQUEST_URL")) + headers).getBytes());
        byteBuffers[0] = statusLineBuffer;
        byteBuffers[1] = headersBuffer;
        OutputWriter.flushChannel((SocketChannel)channel, (ByteBuffer[])byteBuffers);
    }

    private static void redirectSSL(Context context, SSLEngine sslEngine, ByteBuffer outputBB, String httpHeaders) throws IOException {
        SocketChannel channel = (SocketChannel)context.getSelectionKey().channel();
        ByteBuffer statusLineBuffer = SC_FOUND.slice();
        ByteBuffer headersBuffer = ByteBuffer.wrap((httpHeaders + new String((byte[])context.getAttribute("HTTP_REQUEST_URL")) + headers).getBytes());
        ByteBuffer singleBuffer = ByteBuffer.allocate(statusLineBuffer.remaining() + headersBuffer.remaining());
        singleBuffer.put(statusLineBuffer);
        singleBuffer.put(headersBuffer);
        singleBuffer.flip();
        SSLOutputWriter.flushChannel((SelectableChannel)channel, (ByteBuffer)singleBuffer, (ByteBuffer)outputBB, (SSLEngine)sslEngine);
    }

    private static String createHostString(Context context, ByteBuffer byteBuffer, Integer redirectPort) {
        boolean portSpecified = redirectPort != null;
        String host = HttpRedirector.parseHost(byteBuffer, !portSpecified);
        if (host == null) {
            Socket s = ((SocketChannel)context.getSelectionKey().channel()).socket();
            InetAddress address = s.getLocalAddress();
            host = address.getHostName();
            host = host + ':' + Integer.toString(portSpecified ? redirectPort.intValue() : s.getLocalPort());
        } else if (portSpecified) {
            host = host + ':' + Integer.toString(redirectPort);
        }
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String parseHost(ByteBuffer byteBuffer, boolean includePort) {
        int curPosition = byteBuffer.position();
        int curLimit = byteBuffer.limit();
        if (byteBuffer.position() == 0) {
            return null;
        }
        byteBuffer.position(0);
        byteBuffer.limit(curPosition);
        int state = 0;
        int start = 0;
        int end = 0;
        try {
            block14: while (byteBuffer.hasRemaining()) {
                byte c = (byte)Ascii.toLower((int)byteBuffer.get());
                switch (state) {
                    case 0: {
                        if (c == 104) {
                            state = 1;
                            continue block14;
                        }
                        state = 0;
                        continue block14;
                    }
                    case 1: {
                        if (c == 111) {
                            state = 2;
                            continue block14;
                        }
                        state = 0;
                        continue block14;
                    }
                    case 2: {
                        if (c == 115) {
                            state = 3;
                            continue block14;
                        }
                        state = 0;
                        continue block14;
                    }
                    case 3: {
                        if (c == 116) {
                            state = 4;
                            continue block14;
                        }
                        state = 0;
                        continue block14;
                    }
                    case 4: {
                        if (c == 58) {
                            state = 5;
                            continue block14;
                        }
                        state = 0;
                        continue block14;
                    }
                    case 5: {
                        StringBuilder sb = new StringBuilder();
                        while (c != 13 && c != 10 && (c != 58 || includePort)) {
                            sb.append((char)c);
                            c = byteBuffer.get();
                        }
                        String string = sb.toString().trim();
                        return string;
                    }
                }
                throw new IllegalArgumentException("Unexpected state");
            }
            String string = null;
            return string;
        }
        catch (BufferUnderflowException bue) {
            String string = null;
            return string;
        }
        finally {
            if (end > 0) {
                byteBuffer.position(start);
                byteBuffer.limit(end);
            } else {
                byteBuffer.limit(curLimit);
                byteBuffer.position(curPosition);
            }
        }
    }
}

