/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CheckUtils;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;

public final class ParameterAssignmentCheck
extends AbstractCheck {
    public static final String MSG_KEY = "parameter.assignment";
    private final Deque<Set<String>> parameterNamesStack = new ArrayDeque<Set<String>>();
    private Set<String> parameterNames;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{8, 9, 80, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 129, 25, 130, 26};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{8, 9, 80, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 129, 25, 130, 26};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.parameterNamesStack.clear();
        this.parameterNames = Collections.emptySet();
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 8: 
            case 9: {
                this.visitMethodDef(ast);
                break;
            }
            case 80: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                this.visitAssign(ast);
                break;
            }
            case 25: 
            case 26: 
            case 129: 
            case 130: {
                this.visitIncDec(ast);
                break;
            }
            default: {
                throw new IllegalStateException(ast.toString());
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 8: 
            case 9: {
                this.leaveMethodDef();
                break;
            }
            case 25: 
            case 26: 
            case 80: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 129: 
            case 130: {
                break;
            }
            default: {
                throw new IllegalStateException(ast.toString());
            }
        }
    }

    private void visitAssign(DetailAST ast) {
        this.checkIdent(ast);
    }

    private void visitIncDec(DetailAST ast) {
        this.checkIdent(ast);
    }

    private void checkIdent(DetailAST ast) {
        DetailAST identAST;
        if (!this.parameterNames.isEmpty() && (identAST = ast.getFirstChild()) != null && identAST.getType() == 58 && this.parameterNames.contains(identAST.getText())) {
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, identAST.getText());
        }
    }

    private void visitMethodDef(DetailAST ast) {
        this.parameterNamesStack.push(this.parameterNames);
        this.parameterNames = new HashSet<String>();
        this.visitMethodParameters(ast.findFirstToken(20));
    }

    private void leaveMethodDef() {
        this.parameterNames = this.parameterNamesStack.pop();
    }

    private void visitMethodParameters(DetailAST ast) {
        for (DetailAST parameterDefAST = ast.findFirstToken(21); parameterDefAST != null; parameterDefAST = parameterDefAST.getNextSibling()) {
            if (parameterDefAST.getType() != 21 || CheckUtils.isReceiverParameter(parameterDefAST)) continue;
            DetailAST param = parameterDefAST.findFirstToken(58);
            this.parameterNames.add(param.getText());
        }
    }
}

