/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.ResourceBundle;

public class XMLLogger
extends AutomaticBean
implements AuditListener {
    private static final int BASE_10 = 10;
    private static final int BASE_16 = 16;
    private static final String[] ENTITIES = new String[]{"gt", "amp", "lt", "apos", "quot"};
    private final boolean closeStream;
    private PrintWriter writer;

    public XMLLogger(OutputStream outputStream, boolean closeStream) {
        this.setOutputStream(outputStream);
        this.closeStream = closeStream;
    }

    private void setOutputStream(OutputStream outputStream) {
        OutputStreamWriter osw = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        this.writer = new PrintWriter(osw);
    }

    @Override
    public void auditStarted(AuditEvent event) {
        this.writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        ResourceBundle compilationProperties = ResourceBundle.getBundle("checkstylecompilation", Locale.ROOT);
        String version = compilationProperties.getString("checkstyle.compile.version");
        this.writer.println("<checkstyle version=\"" + version + "\">");
    }

    @Override
    public void auditFinished(AuditEvent event) {
        this.writer.println("</checkstyle>");
        if (this.closeStream) {
            this.writer.close();
        } else {
            this.writer.flush();
        }
    }

    @Override
    public void fileStarted(AuditEvent event) {
        this.writer.println("<file name=\"" + XMLLogger.encode(event.getFileName()) + "\">");
    }

    @Override
    public void fileFinished(AuditEvent event) {
        this.writer.println("</file>");
    }

    @Override
    public void addError(AuditEvent event) {
        if (event.getSeverityLevel() != SeverityLevel.IGNORE) {
            this.writer.print("<error line=\"" + event.getLine() + "\"");
            if (event.getColumn() > 0) {
                this.writer.print(" column=\"" + event.getColumn() + "\"");
            }
            this.writer.print(" severity=\"" + event.getSeverityLevel().getName() + "\"");
            this.writer.print(" message=\"" + XMLLogger.encode(event.getMessage()) + "\"");
            this.writer.println(" source=\"" + XMLLogger.encode(event.getSourceName()) + "\"/>");
        }
    }

    @Override
    public void addException(AuditEvent event, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printer = new PrintWriter(stringWriter);
        printer.println("<exception>");
        printer.println("<![CDATA[");
        throwable.printStackTrace(printer);
        printer.println("]]>");
        printer.println("</exception>");
        printer.flush();
        this.writer.println(XMLLogger.encode(stringWriter.toString()));
    }

    public static String encode(String value) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < value.length(); ++i) {
            char chr = value.charAt(i);
            switch (chr) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '&': {
                    sb.append(XMLLogger.encodeAmpersand(value, i));
                    continue block7;
                }
                default: {
                    sb.append(chr);
                }
            }
        }
        return sb.toString();
    }

    public static boolean isReference(String ent) {
        boolean reference = false;
        if (ent.charAt(0) != '&' || !CommonUtils.endsWithChar(ent, ';')) {
            reference = false;
        } else if (ent.charAt(1) == '#') {
            int prefixLength = 2;
            int radix = 10;
            if (ent.charAt(2) == 'x') {
                ++prefixLength;
                radix = 16;
            }
            try {
                Integer.parseInt(ent.substring(prefixLength, ent.length() - 1), radix);
                reference = true;
            }
            catch (NumberFormatException ignored) {
                reference = false;
            }
        } else {
            String name = ent.substring(1, ent.length() - 1);
            for (String element : ENTITIES) {
                if (!name.equals(element)) continue;
                reference = true;
                break;
            }
        }
        return reference;
    }

    private static String encodeAmpersand(String value, int ampPosition) {
        int nextSemi = value.indexOf(59, ampPosition);
        String result = nextSemi < 0 || !XMLLogger.isReference(value.substring(ampPosition, nextSemi + 1)) ? "&amp;" : "&";
        return result;
    }
}

