/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import com.google.common.collect.ImmutableList;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;
import java.util.List;

public class CodeSelectorPModel {
    private final DetailAST ast;
    private final List<Integer> lines2position;
    private int selectionStart;
    private int selectionEnd;

    public CodeSelectorPModel(DetailAST ast, List<Integer> lines2position) {
        this.ast = ast;
        this.lines2position = ImmutableList.copyOf(lines2position);
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public void findSelectionPositions() {
        this.selectionStart = this.lines2position.get(this.ast.getLineNo()) + this.ast.getColumnNo();
        this.selectionEnd = this.ast.getChildCount() == 0 && TokenUtils.getTokenName(this.ast.getType()).equals(this.ast.getText()) ? this.selectionStart : this.findLastPosition(this.ast);
    }

    private int findLastPosition(DetailAST astNode) {
        if (astNode.getChildCount() == 0) {
            return this.lines2position.get(astNode.getLineNo()) + astNode.getColumnNo() + astNode.getText().length();
        }
        return this.findLastPosition(astNode.getLastChild());
    }
}

