/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class WhitespaceAroundCheck
extends Check {
    private boolean mAllowEmptyCtors;
    private boolean mAllowEmptyMethods;
    private boolean mAllowEmptyTypes;
    private boolean mAllowEmptyLoops;
    private boolean mIgnoreEnhancedForColon = true;

    public int[] getDefaultTokens() {
        return new int[]{80, 114, 106, 112, 108, 124, 104, 113, 107, 82, 127, 101, 175, 116, 120, 118, 111, 72, 119, 96, 85, 92, 97, 91, 83, 88, 89, 67, 95, 84, 110, 117, 126, 99, 128, 102, 115, 125, 98, 109, 73, 122, 7, 105, 123, 103, 60, 100, 151, 174};
    }

    public void setAllowEmptyMethods(boolean aAllow) {
        this.mAllowEmptyMethods = aAllow;
    }

    public void setAllowEmptyConstructors(boolean aAllow) {
        this.mAllowEmptyCtors = aAllow;
    }

    public void setIgnoreEnhancedForColon(boolean aIgnore) {
        this.mIgnoreEnhancedForColon = aIgnore;
    }

    public void setAllowEmptyTypes(boolean aAllow) {
        this.mAllowEmptyTypes = aAllow;
    }

    public void setAllowEmptyLoops(boolean aAllow) {
        this.mAllowEmptyLoops = aAllow;
    }

    public void visitToken(DetailAST aAST) {
        int currentType = aAST.getType();
        int parentType = aAST.getParent().getType();
        if (!(currentType != 73 && currentType != 72 || parentType != 29 && parentType != 162)) {
            return;
        }
        if (currentType == 60 && parentType == 59) {
            return;
        }
        if (currentType == 7 && parentType == 33) {
            return;
        }
        if (currentType == 82) {
            if (parentType == 94 || parentType == 93) {
                return;
            }
            if (parentType == 156 && this.mIgnoreEnhancedForColon) {
                return;
            }
        }
        if (this.isEmptyMethodBlock(aAST, parentType) || this.isEmptyCtorBlock(aAST, parentType) || this.isEmptyLoop(aAST, parentType)) {
            return;
        }
        if (this.mAllowEmptyTypes && this.isEmptyType(aAST, parentType)) {
            return;
        }
        String[] lines = this.getLines();
        String line = lines[aAST.getLineNo() - 1];
        int before = aAST.getColumnNo() - 1;
        int after = aAST.getColumnNo() + aAST.getText().length();
        if (before >= 0 && !Character.isWhitespace(line.charAt(before))) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "ws.notPreceded", aAST.getText());
        }
        if (after >= line.length()) {
            return;
        }
        char nextChar = line.charAt(after);
        if (!(Character.isWhitespace(nextChar) || currentType == 88 && aAST.getFirstChild().getType() == 45 || currentType == 73 && (nextChar == ')' || nextChar == ';' || nextChar == ',' || nextChar == '.'))) {
            this.log(aAST.getLineNo(), aAST.getColumnNo() + aAST.getText().length(), "ws.notFollowed", aAST.getText());
        }
    }

    private boolean isEmptyMethodBlock(DetailAST aAST, int aParentType) {
        return this.mAllowEmptyMethods && this.isEmptyBlock(aAST, aParentType, 9);
    }

    private boolean isEmptyCtorBlock(DetailAST aAST, int aParentType) {
        return this.mAllowEmptyCtors && this.isEmptyBlock(aAST, aParentType, 8);
    }

    private boolean isEmptyLoop(DetailAST aAST, int aParentType) {
        return this.mAllowEmptyLoops && (this.isEmptyBlock(aAST, aParentType, 91) || this.isEmptyBlock(aAST, aParentType, 84) || this.isEmptyBlock(aAST, aParentType, 85));
    }

    private boolean isEmptyType(DetailAST aAST, int aParentType) {
        DetailAST typeNode;
        int matchType;
        int type = aAST.getType();
        return !(type != 73 && type != 72 || aParentType != 6 || (matchType = (typeNode = aAST.getParent().getParent()).getType()) != 14 && matchType != 15 && matchType != 154 && matchType != 136 && matchType != 157);
    }

    private boolean isEmptyBlock(DetailAST aAST, int aParentType, int aMatch) {
        int type = aAST.getType();
        if (type == 73) {
            DetailAST grandParent = aAST.getParent().getParent();
            return aParentType == 7 && grandParent.getType() == aMatch;
        }
        return type == 7 && aParentType == aMatch && aAST.getFirstChild().getType() == 73;
    }
}

