/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.whitespace.WrapOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatorWrapCheck
extends AbstractOptionCheck<WrapOption> {
    public OperatorWrapCheck() {
        super(WrapOption.NL, WrapOption.class);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{109, 82, 116, 115, 127, 125, 126, 60, 128, 123, 124, 120, 118, 122, 119, 117, 113, 112, 110, 114, 111, 174, 121};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{109, 82, 116, 115, 127, 125, 126, 60, 128, 123, 124, 120, 118, 122, 119, 117, 113, 112, 110, 114, 111, 121, 174, 80, 101, 98, 99, 100, 102, 103, 104, 105, 107, 108, 106};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        DetailAST parent;
        if (aAST.getType() == 82 && ((parent = aAST.getParent()).getType() == 94 || parent.getType() == 93)) {
            return;
        }
        WrapOption wOp = (WrapOption)((Object)this.getAbstractOption());
        String text = aAST.getText();
        int colNo = aAST.getColumnNo();
        int lineNo = aAST.getLineNo();
        String currentLine = this.getLines()[lineNo - 1];
        if (wOp == WrapOption.NL && !text.equals(currentLine.trim()) && currentLine.substring(colNo + text.length()).trim().length() == 0) {
            this.log(lineNo, colNo, "line.new", text);
        } else if (wOp == WrapOption.EOL && Utils.whitespaceBefore(colNo - 1, currentLine)) {
            this.log(lineNo, colNo, "line.previous", text);
        }
    }
}

