/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.blocks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.blocks.LeftCurlyOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeftCurlyCheck
extends AbstractOptionCheck<LeftCurlyOption> {
    private static final int DEFAULT_MAX_LINE_LENGTH = 80;
    private int mMaxLineLength = 80;
    private boolean mIgnoreEnums = true;

    public LeftCurlyCheck() {
        super(LeftCurlyOption.EOL, LeftCurlyOption.class);
    }

    public void setMaxLineLength(int aMaxLineLength) {
        this.mMaxLineLength = aMaxLineLength;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{15, 14, 157, 154, 8, 9, 155, 84, 95, 96, 97, 67, 89, 85, 83, 92, 91};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        DetailAST brace;
        DetailAST startToken;
        switch (aAST.getType()) {
            case 8: 
            case 9: {
                startToken = this.skipAnnotationOnlyLines(aAST);
                brace = aAST.findFirstToken(7);
                break;
            }
            case 14: 
            case 15: 
            case 154: 
            case 155: 
            case 157: {
                startToken = this.skipAnnotationOnlyLines(aAST);
                DetailAST objBlock = aAST.findFirstToken(6);
                brace = objBlock == null ? null : objBlock.getFirstChild();
                break;
            }
            case 67: 
            case 83: 
            case 84: 
            case 85: 
            case 91: 
            case 95: 
            case 96: 
            case 97: {
                startToken = aAST;
                brace = aAST.findFirstToken(7);
                break;
            }
            case 92: {
                startToken = aAST;
                DetailAST candidate = aAST.getFirstChild();
                brace = candidate.getType() == 7 ? candidate : null;
                break;
            }
            case 89: {
                startToken = aAST;
                brace = aAST.findFirstToken(72);
                break;
            }
            default: {
                startToken = null;
                brace = null;
            }
        }
        if (brace != null && startToken != null) {
            this.verifyBrace(brace, startToken);
        }
    }

    private DetailAST skipAnnotationOnlyLines(DetailAST aAST) {
        DetailAST tokenAfterLast;
        DetailAST modifiers = aAST.findFirstToken(5);
        if (modifiers == null) {
            return aAST;
        }
        DetailAST lastAnnot = this.findLastAnnotation(modifiers);
        if (lastAnnot == null) {
            return aAST;
        }
        DetailAST detailAST = tokenAfterLast = lastAnnot.getNextSibling() != null ? lastAnnot.getNextSibling() : modifiers.getNextSibling();
        if (tokenAfterLast.getLineNo() > lastAnnot.getLineNo()) {
            return tokenAfterLast;
        }
        int lastAnnotLineNumber = lastAnnot.getLineNo();
        while (lastAnnot.getPreviousSibling() != null && lastAnnot.getPreviousSibling().getLineNo() == lastAnnotLineNumber) {
            lastAnnot = lastAnnot.getPreviousSibling();
        }
        return lastAnnot;
    }

    private DetailAST findLastAnnotation(DetailAST aModifiers) {
        DetailAST aAnnot;
        for (aAnnot = aModifiers.findFirstToken(159); aAnnot != null && aAnnot.getNextSibling() != null && aAnnot.getNextSibling().getType() == 159; aAnnot = aAnnot.getNextSibling()) {
        }
        return aAnnot;
    }

    private void verifyBrace(DetailAST aBrace, DetailAST aStartToken) {
        int prevLineLen;
        String braceLine = this.getLines()[aBrace.getLineNo() - 1];
        int n = prevLineLen = aBrace.getLineNo() == 1 ? this.mMaxLineLength : Utils.lengthMinusTrailingWhitespace(this.getLines()[aBrace.getLineNo() - 2]);
        if (braceLine.length() <= aBrace.getColumnNo() + 1 || braceLine.charAt(aBrace.getColumnNo() + 1) != '}') {
            if (this.getAbstractOption() == LeftCurlyOption.NL) {
                if (!Utils.whitespaceBefore(aBrace.getColumnNo(), braceLine)) {
                    this.log(aBrace.getLineNo(), aBrace.getColumnNo(), "line.new", "{");
                }
            } else if (this.getAbstractOption() == LeftCurlyOption.EOL) {
                if (Utils.whitespaceBefore(aBrace.getColumnNo(), braceLine) && prevLineLen + 2 <= this.mMaxLineLength) {
                    this.log(aBrace.getLineNo(), aBrace.getColumnNo(), "line.previous", "{");
                }
                if (!this.hasLineBreakAfter(aBrace)) {
                    this.log(aBrace.getLineNo(), aBrace.getColumnNo(), "line.break.after", new Object[0]);
                }
            } else if (this.getAbstractOption() == LeftCurlyOption.NLOW && aStartToken.getLineNo() != aBrace.getLineNo()) {
                if (aStartToken.getLineNo() + 1 == aBrace.getLineNo()) {
                    if (!Utils.whitespaceBefore(aBrace.getColumnNo(), braceLine)) {
                        this.log(aBrace.getLineNo(), aBrace.getColumnNo(), "line.new", "{");
                    } else if (prevLineLen + 2 <= this.mMaxLineLength) {
                        this.log(aBrace.getLineNo(), aBrace.getColumnNo(), "line.previous", "{");
                    }
                } else if (!Utils.whitespaceBefore(aBrace.getColumnNo(), braceLine)) {
                    this.log(aBrace.getLineNo(), aBrace.getColumnNo(), "line.new", "{");
                }
            }
        }
    }

    private boolean hasLineBreakAfter(DetailAST aLeftCurly) {
        DetailAST nextToken = null;
        if (aLeftCurly.getType() == 7) {
            nextToken = aLeftCurly.getFirstChild();
        } else if (aLeftCurly.getParent().getParent().getType() == 154 && !this.mIgnoreEnums) {
            nextToken = aLeftCurly.getNextSibling();
        }
        return nextToken == null || nextToken.getType() == 73 || aLeftCurly.getLineNo() != nextToken.getLineNo();
    }
}

