/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AbstractClientApplicationBase;
import com.microsoft.aad.msal4j.AcquireTokenByAuthorizationGrantSupplier;
import com.microsoft.aad.msal4j.AuthenticationResult;
import com.microsoft.aad.msal4j.AuthenticationResultSupplier;
import com.microsoft.aad.msal4j.AuthorizationCodeParameters;
import com.microsoft.aad.msal4j.AuthorizationCodeRequest;
import com.microsoft.aad.msal4j.AuthorizationResponseHandler;
import com.microsoft.aad.msal4j.AuthorizationResult;
import com.microsoft.aad.msal4j.HttpListener;
import com.microsoft.aad.msal4j.InteractiveRequest;
import com.microsoft.aad.msal4j.MsalClientException;
import com.microsoft.aad.msal4j.PublicApi;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.StringHelper;
import com.microsoft.aad.msal4j.SystemBrowserOptions;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AcquireTokenByInteractiveFlowSupplier
extends AuthenticationResultSupplier {
    private static final Logger LOG = LoggerFactory.getLogger(AcquireTokenByAuthorizationGrantSupplier.class);
    private PublicClientApplication clientApplication;
    private InteractiveRequest interactiveRequest;
    private BlockingQueue<AuthorizationResult> authorizationResultQueue;
    private HttpListener httpListener;

    AcquireTokenByInteractiveFlowSupplier(PublicClientApplication clientApplication, InteractiveRequest request) {
        super(clientApplication, request);
        this.clientApplication = clientApplication;
        this.interactiveRequest = request;
    }

    @Override
    AuthenticationResult execute() throws Exception {
        AuthorizationResult authorizationResult = this.getAuthorizationResult();
        this.validateState(authorizationResult);
        return this.acquireTokenWithAuthorizationCode(authorizationResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthorizationResult getAuthorizationResult() {
        AuthorizationResult result;
        try {
            SystemBrowserOptions systemBrowserOptions = this.interactiveRequest.interactiveRequestParameters().systemBrowserOptions();
            this.authorizationResultQueue = new LinkedBlockingQueue<AuthorizationResult>();
            AuthorizationResponseHandler authorizationResponseHandler = new AuthorizationResponseHandler(this.authorizationResultQueue, systemBrowserOptions);
            this.startHttpListener(authorizationResponseHandler);
            if (systemBrowserOptions != null && systemBrowserOptions.openBrowserAction() != null) {
                this.interactiveRequest.interactiveRequestParameters().systemBrowserOptions().openBrowserAction().openBrowser(this.interactiveRequest.authorizationUrl());
            } else {
                this.openDefaultSystemBrowser(this.interactiveRequest.authorizationUrl());
            }
            result = this.getAuthorizationResultFromHttpListener();
        }
        finally {
            if (this.httpListener != null) {
                this.httpListener.stopListener();
            }
        }
        return result;
    }

    private void validateState(AuthorizationResult authorizationResult) {
        if (StringHelper.isBlank(authorizationResult.state()) || !authorizationResult.state().equals(this.interactiveRequest.state())) {
            throw new MsalClientException("State returned in authorization result is blank or does not match state sent on outgoing request", "invalid_authorization_result");
        }
    }

    private void startHttpListener(AuthorizationResponseHandler handler) {
        int port = this.interactiveRequest.interactiveRequestParameters().redirectUri().getPort() == -1 ? 0 : this.interactiveRequest.interactiveRequestParameters().redirectUri().getPort();
        this.httpListener = new HttpListener();
        this.httpListener.startListener(port, handler);
        if (port != this.httpListener.port()) {
            this.updateRedirectUrl();
        }
    }

    private void updateRedirectUrl() {
        try {
            URI updatedRedirectUrl = new URI("http://localhost:" + this.httpListener.port());
            this.interactiveRequest.interactiveRequestParameters().redirectUri(updatedRedirectUrl);
            LOG.debug("Redirect URI updated to" + updatedRedirectUrl);
        }
        catch (URISyntaxException ex) {
            throw new MsalClientException("Error updating redirect URI. Not a valid URI format", "invalid_redirect_uri");
        }
    }

    private void openDefaultSystemBrowser(URL url) {
        try {
            if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                throw new MsalClientException("Unable to open default system browser", "desktop_browser_not_supported");
            }
            Desktop.getDesktop().browse(url.toURI());
            LOG.debug("Opened default system browser");
        }
        catch (IOException | URISyntaxException ex) {
            throw new MsalClientException(ex);
        }
    }

    private AuthorizationResult getAuthorizationResultFromHttpListener() {
        AuthorizationResult result = null;
        try {
            LOG.debug("Listening for authorization result");
            long expirationTime = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) + 120L;
            while (result == null && !this.interactiveRequest.futureReference().get().isCancelled() && TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) < expirationTime) {
                result = this.authorizationResultQueue.poll(100L, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            throw new MsalClientException(e);
        }
        if (result == null || StringHelper.isBlank(result.code())) {
            throw new MsalClientException("No Authorization code was returned from the server", "invalid_authorization_result");
        }
        return result;
    }

    private AuthenticationResult acquireTokenWithAuthorizationCode(AuthorizationResult authorizationResult) throws Exception {
        AuthorizationCodeParameters parameters = AuthorizationCodeParameters.builder(authorizationResult.code(), this.interactiveRequest.interactiveRequestParameters().redirectUri()).scopes(this.interactiveRequest.interactiveRequestParameters().scopes()).codeVerifier(this.interactiveRequest.verifier()).build();
        AuthorizationCodeRequest authCodeRequest = new AuthorizationCodeRequest(parameters, (AbstractClientApplicationBase)this.clientApplication, this.clientApplication.createRequestContext(PublicApi.ACQUIRE_TOKEN_BY_AUTHORIZATION_CODE, parameters));
        AcquireTokenByAuthorizationGrantSupplier acquireTokenByAuthorizationGrantSupplier = new AcquireTokenByAuthorizationGrantSupplier(this.clientApplication, authCodeRequest, this.clientApplication.authenticationAuthority);
        return acquireTokenByAuthorizationGrantSupplier.execute();
    }
}

