/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource.task;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.resource.AzureResources;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupDraft;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class CreateResourceGroupTask
extends AzureTask<ResourceGroup> {
    private final String subscriptionId;
    private final String resourceGroupName;
    private final Region region;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public CreateResourceGroupTask(String subscriptionId, String resourceGroupName, Region region) {
        this.subscriptionId = subscriptionId;
        this.resourceGroupName = resourceGroupName;
        this.region = region;
    }

    @Override
    @AzureOperation(name="group.create.rg", params={"this.resourceGroupName"}, type=AzureOperation.Type.SERVICE)
    public ResourceGroup doExecute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ResourceGroup rg = (ResourceGroup)Azure.az(AzureResources.class).groups(this.subscriptionId).getOrDraft(this.resourceGroupName, this.resourceGroupName);
            if (rg.isDraftForCreating()) {
                ResourceGroupDraft draft = (ResourceGroupDraft)rg;
                draft.setRegion(this.region);
                draft.createIfNotExist();
            }
            ResourceGroup resourceGroup = rg;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return resourceGroup;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static {
        CreateResourceGroupTask.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CreateResourceGroupTask.java", CreateResourceGroupTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doExecute", "com.microsoft.azure.toolkit.lib.resource.task.CreateResourceGroupTask", "", "", "", "com.microsoft.azure.toolkit.lib.resource.ResourceGroup"), 34);
    }
}

