/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.widgets;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.ui.VradiMainUI;
import com.jurismarches.vradi.ui.widgets.MultipleSelectionHandler;
import com.jurismarches.vradi.ui.widgets.MultipleSelectionPane;
import java.awt.Desktop;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.entities.BusinessEntity;

public abstract class MultipleSelectionFileHandler<B extends BusinessEntity, H>
extends MultipleSelectionHandler<File, B, H> {
    private static final Log log = LogFactory.getLog(MultipleSelectionFileHandler.class);

    public MultipleSelectionFileHandler(MultipleSelectionPane ui, Class<H> handler, String lblKey) {
        super(ui, handler);
        ui.setLbl(I18n._((String)lblKey));
    }

    @Override
    public void init() {
        Set<String> files = this.getFiles();
        this.fillList(files);
    }

    @Override
    public void add() {
        File file = this.addFiles(this.ui, this.getBean());
        if (file != null) {
            this.addToList(file, file.getName());
        }
    }

    @Override
    public void remove() {
        List<String> filesNames = this.removeFiles(this.getBean(), this.getSelectedInList());
        this.removeFromList(filesNames);
    }

    @Override
    public void openSelected(String selected) {
        try {
            File file = this.downloadFile(selected, this.getBean().getWikittyId());
            Desktop.getDesktop().open(file);
        }
        catch (Exception eee) {
            log.error((Object)("Error on download file : " + selected), (Throwable)eee);
            this.fileNotFound(selected);
        }
    }

    public void fileNotFound(String selected) {
        VradiMainUI ui = (VradiMainUI)VradiContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get());
        JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.error.fileNotFound", (Object[])new Object[]{selected}), I18n._((String)"vradi.error.fileNotFound.title"), 0, 0);
    }

    public abstract File downloadFile(String var1, String var2) throws VradiException;

    public abstract List<String> removeFiles(B var1, List<String> var2);

    public abstract Set<String> getFiles();

    public abstract File addFiles(MultipleSelectionPane var1, B var2);
}

