/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.models;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiExtensionsListener;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.models.FormMenu;
import com.jurismarches.vradi.ui.search.SearchUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.WikittyExtension;

public class RequestFieldMenu
extends JMenu
implements VradiExtensionsListener {
    private static final Log log = LogFactory.getLog(FormMenu.class);
    public static final String FIELD_NAME_SUFFIX = ":\"\"";
    protected SearchUI searchUI;
    protected Map<String, JMenu> formTypesMenu;
    protected Map<String, JMenuItem> formTypesFieldMenu;

    public RequestFieldMenu(SearchUI searchUI) {
        super(I18n._((String)"vradi.request.keywords"));
        this.searchUI = searchUI;
        this.fillInfogeneMenu();
        List formTypes = null;
        try {
            formTypes = VradiService.getVradiDataService().getAllFormTypes();
        }
        catch (VradiException eee) {
            log.error((Object)"cant get all forms type", (Throwable)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
        }
        Collections.sort(formTypes, VradiComparators.EXTENSION_COMPARATOR);
        this.formTypesMenu = new HashMap<String, JMenu>();
        this.formTypesFieldMenu = new HashMap<String, JMenuItem>();
        if (formTypes != null) {
            for (WikittyExtension formType : formTypes) {
                this.fillFormTypeMenu(formType);
            }
        }
        VradiContext.get().getVradiNotifier().addVradiListener(this);
    }

    protected void fillInfogeneMenu() {
        JMenu infogeneMenu = new JMenu(I18n._((String)"vradi.request.infogene"));
        for (String fieldName : this.getInfogeneFieldNames()) {
            infogeneMenu.add(new FieldMenuItem(fieldName));
        }
        for (String fieldName : this.getFormFieldNames()) {
            infogeneMenu.add(new FieldMenuItem(fieldName));
        }
        this.add(infogeneMenu);
    }

    protected void fillFormTypeMenu(WikittyExtension formType) {
        String formTypeName = formType.getName();
        JMenu formTypeMenu = new JMenu(formTypeName);
        for (String fieldName : formType.getFieldNames()) {
            FieldMenuItem fieldMenu = new FieldMenuItem(formType, fieldName);
            formTypeMenu.add(fieldMenu);
            this.formTypesFieldMenu.put(fieldName, fieldMenu);
        }
        this.formTypesMenu.put(formTypeName, formTypeMenu);
        this.add(formTypeMenu);
    }

    protected List<String> getInfogeneFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("Infogene.id");
        fieldNames.add("Infogene.objet");
        fieldNames.add("Infogene.description");
        fieldNames.add("Infogene.creationDate");
        fieldNames.add("Infogene.entity");
        fieldNames.add("Infogene.sourceText");
        fieldNames.add("Infogene.sourceURL");
        fieldNames.add("Infogene.country");
        fieldNames.add("Infogene.department");
        fieldNames.add("Infogene.status");
        return fieldNames;
    }

    protected List<String> getFormFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("Form.datePub");
        fieldNames.add("Form.datePeremption");
        fieldNames.add("ModificationTag.lastModifier");
        return fieldNames;
    }

    @Override
    public void extensionsAdded(Set<WikittyExtension> added) {
        for (WikittyExtension ext : added) {
            this.fillFormTypeMenu(ext);
        }
    }

    @Override
    public void extensionsRemoved(Set<String> removedNames) {
        for (String formTypeName : removedNames) {
            JMenu formTypeMenu = this.formTypesMenu.get(formTypeName);
            if (formTypeMenu == null) continue;
            this.formTypesMenu.remove(formTypeName);
            this.remove(formTypeMenu);
        }
    }

    protected class FieldMenuItem
    extends JMenuItem
    implements ActionListener {
        protected String fieldName;
        protected FieldType fieldType;
        protected String description;
        protected String traduction;

        public FieldMenuItem(String fqFieldName) {
            this(null, fqFieldName);
        }

        public FieldMenuItem(WikittyExtension extension, String fqFieldName) {
            this.fieldName = fqFieldName;
            int i = fqFieldName.indexOf(46);
            this.fieldName = i != -1 ? WikittyUtil.getFieldNameFromFQFieldName((String)fqFieldName) : fqFieldName;
            if (extension != null) {
                this.fieldType = extension.getFieldType(fqFieldName);
                this.description = VradiHelper.getFieldTypeDescription(this.fieldType);
            }
            this.traduction = VradiHelper.getTraduction(extension, fqFieldName);
            this.addActionListener(this);
        }

        @Override
        public String getText() {
            if (this.traduction != null && !this.traduction.equals(this.fieldName)) {
                return this.traduction + " (" + this.fieldName + ")";
            }
            return this.fieldName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RSyntaxTextArea requestArea = RequestFieldMenu.this.searchUI.getRequestArea();
            int position = requestArea.getCaretPosition();
            requestArea.insert(this.fieldName + RequestFieldMenu.FIELD_NAME_SUFFIX, position);
            requestArea.setCaretPosition(position + this.fieldName.length() + 2);
            RequestFieldMenu.this.searchUI.setRequest(requestArea.getText());
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            return this.getToolTipText();
        }

        @Override
        public String getToolTipText() {
            if (this.description != null) {
                return this.description;
            }
            return super.getToolTipText();
        }
    }
}

