/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.widget;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiEntitiesListener;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.widget.AdminListSelectorHandler;
import java.util.List;
import java.util.Set;
import jaxx.runtime.swing.ListSelectorUI;
import org.nuiton.wikitty.WikittyProxy;

public class GroupListSelectorHandler
extends AdminListSelectorHandler<Group> {
    protected User bean;
    protected VradiEntitiesListener<User> userVradiEntitiesListener;

    public GroupListSelectorHandler(ListSelectorUI<Group> listSelector) {
        super(listSelector);
        VradiContext.get().getVradiNotifier().addVradiListener(Group.class, this);
        this.userVradiEntitiesListener = new VradiEntitiesListener<User>(){

            @Override
            public void entitiesAdded(Set<User> added) {
                if (added.contains(GroupListSelectorHandler.this.bean)) {
                    GroupListSelectorHandler.this.updateAll();
                }
            }

            @Override
            public void entitiesRemoved(Set<String> removed) {
            }
        };
        VradiContext.get().getVradiNotifier().addVradiListener(User.class, this.userVradiEntitiesListener);
    }

    public User getBean() {
        return this.bean;
    }

    public void setBean(User bean) {
        this.bean = bean;
    }

    protected void updateAll() {
        String wikittyId = this.bean.getWikittyId();
        this.bean = (User)VradiService.getWikittyProxy().restore(User.class, this.bean.getWikittyId());
        this.updateCombo(wikittyId);
        this.updateList(wikittyId);
    }

    protected void updateList(String wikittyId) {
        List groups = VradiService.getVradiDataService().findUserGroups(wikittyId);
        this.setListDatas(groups);
        this.idsInList.clear();
        this.idsInList.addAll(VradiHelper.extractIds(groups));
    }

    protected void updateCombo(String wikittyId) {
        VradiDataService vradiDataService = VradiService.getVradiDataService();
        List allGroups = vradiDataService.findAllGroups();
        List groups = vradiDataService.findUserGroups(wikittyId);
        allGroups.removeAll(groups);
        this.setComboDatas(allGroups);
        this.idsInCombo.clear();
        this.idsInCombo.addAll(VradiHelper.extractIds(allGroups));
    }

    @Override
    public void entitiesAdded(Set<Group> groupAdded) {
        if (this.bean == null) {
            return;
        }
        for (Group added : groupAdded) {
            String wikittyId = added.getWikittyId();
            if (added.getUser() != null && added.getUser().contains(this.bean.getWikittyId())) {
                if (this.idsInList.contains(wikittyId)) continue;
                this.updateAll();
                continue;
            }
            if (this.idsInList.contains(wikittyId)) {
                this.updateAll();
                continue;
            }
            if (this.idsInCombo.contains(wikittyId)) continue;
            this.idsInCombo.add(wikittyId);
            WikittyProxy proxy = VradiService.getWikittyProxy();
            this.setComboDatas(proxy.restore(Group.class, this.idsInCombo));
        }
    }

    @Override
    public void entitiesRemoved(Set<String> removed) {
        for (String wikittyId : removed) {
            List groups;
            WikittyProxy proxy = VradiService.getWikittyProxy();
            if (this.idsInCombo.contains(wikittyId)) {
                this.idsInCombo.remove(wikittyId);
                groups = proxy.restore(Group.class, this.idsInCombo);
                this.setComboDatas(groups);
            }
            if (!this.idsInList.contains(wikittyId)) continue;
            this.idsInList.remove(wikittyId);
            groups = proxy.restore(Group.class, this.idsInList);
            this.setListDatas(groups);
        }
    }
}

