/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import com.jurismarches.vradi.VradiConfig;
import com.jurismarches.vradi.VradiConfigHelper;
import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.beans.QueryParameters;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import java.awt.Color;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.addons.WikittyI18nUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyI18n;

public class VradiHelper {
    private static final Log log = LogFactory.getLog(VradiHelper.class);
    public static final String TYPE_DESCRIPTION = "description";
    public static final String TYPE_RANK = "rank";
    public static final String TYPE_LAST_MODIFIED_DATE = "lastModifiedDate";
    public static final String TYPE_LAST_MODIFIED_TIME = "lastModifiedTime";
    public static final String TYPE_LAST_MODIFIED_BY = "lastModifiedBy";
    public static final String INFOGENE_KEY_PREFIX = "vradi.infogene.";
    public static final String FORM_KEY_PREFIX = "vradi.form.";
    public static final String MODIFICATION_TAG_KEY_PREFIX = "vradi.modificationTag.";

    public static VradiConfig getVradiConfig() {
        return VradiContext.get().getVradiConfig();
    }

    public static Status getSelectionneStatus() {
        VradiConstants.FormStatus type = VradiConstants.FormStatus.SELECTIONNE;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getOrCreateStatus(" + type.getName() + ")"));
        }
        try {
            return VradiService.getVradiDataService().getStatus(type.getName());
        }
        catch (VradiException eee) {
            log.error((Object)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
            return null;
        }
    }

    protected static List<String> stringToList(String string) {
        ArrayList<String> resultList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)string)) {
            String[] items = StringUtil.split((String)string, (String)",");
            resultList.addAll(Arrays.asList(items));
        }
        return resultList;
    }

    public static void addRequestToProperties(String query) {
        List<String> result = VradiHelper.loadRequests();
        if (!result.contains(query)) {
            result.add(0, query);
            String queries = StringUtils.join(result, (String)",");
            VradiConfigHelper.setQueries(VradiHelper.getVradiConfig(), queries);
        }
    }

    public static List<String> loadRequests() {
        String queries = VradiConfigHelper.getQueries(VradiHelper.getVradiConfig());
        List<String> result = VradiHelper.stringToList(queries);
        return result;
    }

    public static List<String> getVradiListCriteria() {
        String criterias = VradiConfigHelper.getCriterias(VradiHelper.getVradiConfig());
        List<String> result = VradiHelper.stringToList(criterias);
        return result;
    }

    public static void addVradiListCriteria(Thesaurus value) {
        if (value == null) {
            return;
        }
        List<String> result = VradiHelper.getVradiListCriteria();
        result.add(value.getWikittyId());
        String criterias = StringUtils.join(result, (char)',');
        VradiConfigHelper.setCriterias(VradiHelper.getVradiConfig(), criterias);
    }

    public static void removeVradiListCriteria(Thesaurus value) {
        if (value == null) {
            return;
        }
        List<String> result = VradiHelper.getVradiListCriteria();
        result.remove(value.getWikittyId());
        String criterias = StringUtils.join(result, (char)',');
        VradiConfigHelper.setCriterias(VradiHelper.getVradiConfig(), criterias);
    }

    public static List<String> getVradiListRootCriteria() {
        String criterias = VradiConfigHelper.getRootCriterias(VradiHelper.getVradiConfig());
        List<String> result = VradiHelper.stringToList(criterias);
        return result;
    }

    public static void addVradiListRootCriteria(RootThesaurus value) {
        if (value == null) {
            return;
        }
        List<String> result = VradiHelper.getVradiListRootCriteria();
        result.add(value.getWikittyId());
        String criterias = StringUtils.join(result, (char)',');
        VradiConfigHelper.setRootCriterias(VradiHelper.getVradiConfig(), criterias);
    }

    public static void removeVradiListRootCriteria(RootThesaurus value) {
        List<String> result = VradiHelper.getVradiListRootCriteria();
        result.remove(value.getWikittyId());
        String criterias = StringUtils.join(result, (char)',');
        VradiConfigHelper.setRootCriterias(VradiHelper.getVradiConfig(), criterias);
    }

    public static List<String> getVradiListRootThesaurus() {
        String rootThesaurus = VradiConfigHelper.getRootThesaurus(VradiHelper.getVradiConfig());
        List<String> result = VradiHelper.stringToList(rootThesaurus);
        return result;
    }

    public static void removeVradiListRootThesaurus(RootThesaurus value) {
        if (value == null) {
            return;
        }
        List<String> result = VradiHelper.getVradiListRootThesaurus();
        result.remove(value.getWikittyId());
        String rootThesaurus = StringUtils.join(result, (char)',');
        VradiConfigHelper.setRootThesaurus(VradiHelper.getVradiConfig(), rootThesaurus);
    }

    public static void addVradiListRootThesaurus(RootThesaurus value) {
        if (value == null) {
            return;
        }
        List<String> result = VradiHelper.getVradiListRootThesaurus();
        result.add(value.getWikittyId());
        String rootThesaurus = StringUtils.join(result, (char)',');
        VradiConfigHelper.setRootThesaurus(VradiHelper.getVradiConfig(), rootThesaurus);
    }

    public static List<String> getVradiListThesaurus() {
        String rootThesaurus = VradiConfigHelper.getThesaurus(VradiHelper.getVradiConfig());
        List<String> result = VradiHelper.stringToList(rootThesaurus);
        return result;
    }

    public static void removeVradiListThesaurus(Thesaurus value) {
        if (value == null) {
            return;
        }
        List<String> result = VradiHelper.getVradiListThesaurus();
        result.remove(value.getWikittyId());
        String thesaurus = StringUtils.join(result, (char)',');
        VradiConfigHelper.setThesaurus(VradiHelper.getVradiConfig(), thesaurus);
    }

    public static void addVradiListThesaurus(Thesaurus value) {
        if (value == null) {
            return;
        }
        List<String> result = VradiHelper.getVradiListThesaurus();
        result.add(value.getWikittyId());
        String thesaurus = StringUtils.join(result, (char)',');
        VradiConfigHelper.setThesaurus(VradiHelper.getVradiConfig(), thesaurus);
    }

    public static List<String> getVradiListColumns() {
        String columns = VradiConfigHelper.getOfferColumns(VradiHelper.getVradiConfig());
        List<String> result = VradiHelper.stringToList(columns);
        return result;
    }

    public static void removeVradiListColumns(String columnName) {
        List<String> result = VradiHelper.getVradiListColumns();
        result.remove(columnName);
        String columns = StringUtils.join(result, (char)',');
        VradiConfigHelper.setOfferColumns(VradiHelper.getVradiConfig(), columns);
    }

    public static void addVradiListColumns(String columnName) {
        List<String> result = VradiHelper.getVradiListColumns();
        result.add(columnName);
        String columns = StringUtils.join(result, (char)',');
        VradiConfigHelper.setOfferColumns(VradiHelper.getVradiConfig(), columns);
    }

    public static Map<Integer, Color> getColorsThesaurus() {
        HashMap<Integer, Color> levelsAndColors = new HashMap<Integer, Color>();
        String thesaurusColors = VradiConfigHelper.getThesaurusColors(VradiHelper.getVradiConfig());
        if (StringUtils.isNotEmpty((String)thesaurusColors)) {
            String[] thesaurusColorsItems;
            for (String thesaurusColorsItem : thesaurusColorsItems = StringUtil.split((String)thesaurusColors, (String)",")) {
                if (thesaurusColorsItem.indexOf(61) <= 0) continue;
                String[] levelAndColor = thesaurusColorsItem.split("=|;");
                Integer level = Integer.parseInt(levelAndColor[0]);
                Color color = new Color(Integer.parseInt(levelAndColor[1]), Integer.parseInt(levelAndColor[2]), Integer.parseInt(levelAndColor[3]));
                levelsAndColors.put(level, color);
            }
        }
        if (levelsAndColors.isEmpty()) {
            Color[] colors = new Color[]{Color.BLACK, Color.BLUE, Color.CYAN, Color.DARK_GRAY, Color.GRAY, Color.GREEN, Color.LIGHT_GRAY, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.RED, Color.YELLOW};
            for (int level = 0; level < colors.length; ++level) {
                levelsAndColors.put(level, colors[level]);
            }
        }
        return levelsAndColors;
    }

    public static void storeThesaurusColor(int level, Color color) {
        Map<Integer, Color> levelsAndColors = VradiHelper.getColorsThesaurus();
        levelsAndColors.put(level, color);
        StringBuilder levelAndColorConf = new StringBuilder("");
        for (Map.Entry<Integer, Color> entry : levelsAndColors.entrySet()) {
            String stringLevel = entry.getKey().toString();
            String stringColor = entry.getValue().getRed() + ";" + entry.getValue().getGreen() + ";" + entry.getValue().getBlue();
            levelAndColorConf.append(stringLevel);
            levelAndColorConf.append("=");
            levelAndColorConf.append(stringColor);
            levelAndColorConf.append(",");
        }
        VradiConfigHelper.setThesaurusColors(VradiHelper.getVradiConfig(), levelAndColorConf.toString());
    }

    public static boolean isOnClickThesaurusExpanded() {
        boolean result = VradiConfigHelper.isOnClickThesaurusExpanded(VradiHelper.getVradiConfig());
        return result;
    }

    public static void storeOnClickThesaurusExpanded(boolean expendSelected) {
        VradiConfigHelper.setOnClickThesaurusExpanded(VradiHelper.getVradiConfig(), expendSelected);
    }

    public static String getEntityName(Object o) {
        if (o == null) {
            return "";
        }
        try {
            PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor((Object)o, (String)"name");
            if (descriptor == null) {
                return "";
            }
            Method getter = descriptor.getReadMethod();
            Object invoke = getter.invoke(o, new Object[0]);
            if (invoke == null) {
                return "";
            }
            String result = (String)invoke;
            return result;
        }
        catch (IllegalAccessException e) {
            log.error((Object)e);
            ErrorDialogUI.showError((Exception)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e);
            ErrorDialogUI.showError((Exception)e);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e);
            ErrorDialogUI.showError((Exception)e);
        }
        return "";
    }

    public static FormPagedResult executeQuery(QueryParameters queryParameters, FormPagedResult formPagedResult) {
        try {
            formPagedResult.setTotalFoundFormNb(0);
            if (formPagedResult.getNbFormsToShow() == 0) {
                formPagedResult.setNbFormsToShow(10);
            }
            if (formPagedResult.getPageToShow() == 0) {
                formPagedResult.setPageToShow(1);
            }
            formPagedResult = VradiService.getVradiDataService().findForms(queryParameters, formPagedResult);
            if (log.isDebugEnabled()) {
                log.debug((Object)(formPagedResult.getTotalFoundFormNb() + " forms found"));
                List formsIds = formPagedResult.getFormsIdsToShow();
                List forms = VradiService.getWikittyProxy().restore(Form.class, formsIds);
                for (Form form : forms) {
                    log.debug((Object)(form.getWikittyId() + " : " + form.getObjet()));
                }
            }
        }
        catch (VradiException eee) {
            log.error((Object)"Cant execute query : ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
            formPagedResult = new FormPagedResult();
        }
        catch (UnsupportedQueryException e) {
            log.error((Object)e.getMessage());
            ErrorDialogUI.showError((Exception)((Object)e));
            formPagedResult = new FormPagedResult();
        }
        return formPagedResult;
    }

    public static String getFieldTypeDescription(FieldType fieldType) {
        return fieldType == null ? null : fieldType.getTagValue(TYPE_DESCRIPTION);
    }

    public static int getFieldTypeRank(FieldType fieldType) {
        int result;
        try {
            result = Integer.valueOf(fieldType.getTagValue(TYPE_RANK));
        }
        catch (NumberFormatException eee) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"no tag value for rank");
            }
            result = -1;
        }
        return result;
    }

    public static boolean isVersionNewer(String version) {
        String lastVersion = VradiConfigHelper.getLastVersion(VradiHelper.getVradiConfig());
        if (StringUtils.isEmpty((String)lastVersion)) {
            return true;
        }
        String[] versionToken = version.split("\\.");
        String[] lastVersionToken = lastVersion.split("\\.");
        for (int i = 0; i < versionToken.length && i < lastVersionToken.length; ++i) {
            if (Integer.valueOf(versionToken[i]) > Integer.valueOf(lastVersionToken[i])) {
                return true;
            }
            if (Integer.valueOf(versionToken[i]) >= Integer.valueOf(lastVersionToken[i])) continue;
            return false;
        }
        return false;
    }

    public static List<String> extractIds(Collection<? extends BusinessEntity> beans) {
        ArrayList<String> ids = new ArrayList<String>();
        for (BusinessEntity businessEntity : beans) {
            ids.add(businessEntity.getWikittyId());
        }
        return ids;
    }

    public static Form initForm(Form form) {
        String newId = VradiConstants.FORM_ID_DATE_FORMAT.format(new GregorianCalendar().getTime()) + form.getWikittyId();
        form.setId(newId);
        form.setCreationDate(new Date());
        return form;
    }

    public static String getTraduction(String fieldName) {
        return VradiHelper.getTraduction((WikittyI18n)null, fieldName);
    }

    public static String getTraduction(WikittyExtension extension, String fieldName) {
        WikittyI18n wikittyI18n = null;
        if (extension != null) {
            wikittyI18n = WikittyI18nUtil.getI18n((WikittyProxy)VradiService.getWikittyProxy(), (WikittyExtension)extension);
        }
        return VradiHelper.getTraduction(wikittyI18n, fieldName);
    }

    public static String getTraduction(WikittyI18n wikittyI18n, String fqFieldNames) {
        if (fqFieldNames == null) {
            return null;
        }
        String result = null;
        String fieldName = fqFieldNames;
        int i = fieldName.indexOf(46);
        if (i != -1) {
            fieldName = WikittyUtil.getFieldNameFromFQFieldName((String)fqFieldNames);
        }
        if (wikittyI18n != null) {
            result = wikittyI18n.getTranslation(VradiHelper.getCurrentLocale().getLanguage(), fieldName);
        }
        if (result == null || result.equals(fieldName) || "".equals(result)) {
            result = fqFieldNames.matches("Infogene\\..*") ? VradiHelper.getInfogeneTraduction(fqFieldNames) : (fqFieldNames.matches("Form\\..*") ? VradiHelper.getFormTraduction(fqFieldNames) : (fqFieldNames.matches("ModificationTag\\..*") ? VradiHelper.getModificationTagTraduction(fqFieldNames) : fieldName));
        }
        return I18n._((String)result);
    }

    public static String getInfogeneTraduction(String key) {
        key = WikittyUtil.getFieldNameFromFQFieldName((String)key);
        return I18n._((String)(INFOGENE_KEY_PREFIX + key));
    }

    public static String getFormTraduction(String key) {
        key = WikittyUtil.getFieldNameFromFQFieldName((String)key);
        return I18n._((String)(FORM_KEY_PREFIX + key));
    }

    public static String getModificationTagTraduction(String key) {
        key = WikittyUtil.getFieldNameFromFQFieldName((String)key);
        return I18n._((String)(MODIFICATION_TAG_KEY_PREFIX + key));
    }

    public static Locale getCurrentLocale() {
        VradiConfig config = VradiContext.get().getVradiConfig();
        return VradiConfigHelper.getLocale(config);
    }

    public static String join(Collection collection, String separator, char endOfLine, int prefferedSize) {
        String joined = StringUtils.join((Collection)collection, (String)separator);
        StringBuilder result = new StringBuilder();
        while (joined.length() > prefferedSize) {
            String part = joined.substring(0, prefferedSize);
            int separatorIndex = part.lastIndexOf(separator);
            if (separatorIndex == -1) {
                int i = joined.indexOf(separator);
                if (i == -1) {
                    part = joined;
                } else {
                    separatorIndex = i + separator.length();
                    part = joined.substring(0, separatorIndex) + endOfLine;
                }
            } else {
                part = part.substring(0, separatorIndex += separator.length()) + endOfLine;
            }
            result.append(part);
            joined = joined.substring(separatorIndex, joined.length());
        }
        result.append(joined);
        return result.toString();
    }
}

