/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer.editors;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.editors.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class TextEditor extends com.jurismarches.vradi.ui.offer.editors.VradiEditor<String, TextEditorModel> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CONVERT_TO_ISO_ENABLED = "convertToIso.enabled";
    public static final String BINDING_CONVERT_TO_UTF_ENABLED = "convertToUtf.enabled";
    public static final String BINDING_EDITOR_ENABLED = "editor.enabled";
    public static final String BINDING_EDITOR_TEXT = "editor.text";
    public static final String BINDING_REMOVE_END_LINE_BUTTON_ENABLED = "removeEndLineButton.enabled";
    public static final String BINDING_REMOVE_XML_ENABLED = "removeXML.enabled";
    public static final String BINDING_UNESCAPE_XML_ENABLED = "unescapeXML.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVS2/TQBCehqYlffBoaKECRIEKISE5qBIPqRXQFioeKVQkVIVc2MRbstXaa3bXweWA+An8BLhzQeLGCXHgzIEL4i8gxIErYtZO4waMMSQHJ5qZ75v5xjOTl18gryQc3SBBYEnf1cyh1vX5tbVb9Q3a0JepakjmaSEh+vTlIFeDYbtjVxqO18oGXmrDS4vC8YRL3W3o2TIMKb3JqWpSqjUc7kY0lCpVOu7ZwPPlFmunqCTW59++5p7ZT1/kAAIPqxtBKVN/Q8VK+suQY7aGMczUIiVO3AdYhmTuA6x31NgWOVHqJnHoQ3gCg2UY8IhEMg3HsksOOUJ84GkYnV6VxGZXbIYxpzXMNIRjbfiSKYfIRpMqq2X8ls8ssb5OpUXDSGVVaaAjlOeFdAMa8o6wKddw7t9Jlg0yZiq0CGc2QYeGU10d7Dgs9Qg7Y1XMc3XLGDOMRjkWhavDDo2Z/gVt0PUV4m5PtycKrjSk4Nz4NOzvio89BjHWAQ5EQA3jXeFG17ykxESNx8HTqwsiOB1yb1MUYYyrm7soqSNa9Iprl5lLF3ytUQsUuxJFVgM42MGNNITbolJXxTUljG3qT/47ej3BX4jyri2XE5zDvosjRbxf3RIOdonCFbLiFYpnvK8GeemjWcOB2u9bdxtd0b4d+GXfDGHo/TFR/Pjm8+ulrSXbh7nHE0O33Qgcfk8KD1Uzk3p3tGG+Zry0TLzZGhQU5XhgwgNyKKGwStuNxWG+vQZuGbh1lagmUuQHP719N3H/ww7ILcEQF8ReIib+GhR0U2IXBLcD7+KlsKKRRzvxucfUhlPByabA1wi75nCEyVSduTa+2wsBNuFQQhM6ldQL778XK68ubTWiDwub/GN43Iz8PRhgLseZCu9N+5Qk3pdhT1HfFvHJSDoifea76LW3yQqfM0lKJ5tCssc4xIRH+7RA5IrgrLFpIGcC33ydDZWYX+dD4okMxIPUJXVO7RSayQw0ww5zmeM7FfaY9kjVr/EC9MRhzPMpDEcyMdzAwzcXvewpovG/pO5reuF/GbFFWgheZV61La/aS3Fp8o5lk5dSQzaGuz0zpKmY7llFNoY0FdkY0lSc6FlFNoY0FdkY0lSc7FlFNoY0FYbhJ94ehKzjCgAA";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.offer.editors.TextEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton convertToIso;
    protected javax.swing.JButton convertToUtf;
    protected javax.swing.JTextArea editor;
    protected javax.swing.JScrollPane editorScrollPane;
    protected com.jurismarches.vradi.ui.offer.editors.TextEditorModel model;
    protected javax.swing.JButton removeEndLineButton;
    protected javax.swing.JButton removeXML;
    protected javax.swing.JButton unescapeXML;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.offer.editors.TextEditorModel > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private TextEditor $VradiEditor0 = this;
    private jaxx.runtime.swing.VBox $VBox0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void registerValidator() {
                validator.setBean(model);
                getContextValue(jaxx.runtime.validator.swing.SwingValidatorMessageTableModel.class,"errorEditorTable")
                        .registerValidator(validator);
            }
            void $afterCompleteSetup() {
                // scroll more efficiently
                editorScrollPane.getVerticalScrollBar().setBlockIncrement(100);
                editorScrollPane.getVerticalScrollBar().setUnitIncrement(50);
            }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TextEditor() {
        super();
        $initialize();
    }

    public TextEditor(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.offer.editors.TextEditorModel > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__convertToIso(java.awt.event.ActionEvent event) {
        model.convertToIso();
    }

    public void doActionPerformed__on__convertToUtf(java.awt.event.ActionEvent event) {
        model.convertToUtf();
    }

    public void doActionPerformed__on__removeEndLineButton(java.awt.event.ActionEvent event) {
        model.removeEndLine();
    }

    public void doActionPerformed__on__removeXML(java.awt.event.ActionEvent event) {
        model.removeXML();
    }

    public void doActionPerformed__on__unescapeXML(java.awt.event.ActionEvent event) {
        model.unescapeXML();
    }

    public void doKeyReleased__on__editor(java.awt.event.KeyEvent event) {
        setValue(editor.getText());revalidate();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getConvertToIso() {
        return convertToIso;
    }

    public javax.swing.JButton getConvertToUtf() {
        return convertToUtf;
    }

    public javax.swing.JTextArea getEditor() {
        return editor;
    }

    public javax.swing.JScrollPane getEditorScrollPane() {
        return editorScrollPane;
    }

    public com.jurismarches.vradi.ui.offer.editors.TextEditorModel getModel() {
        return model;
    }

    public javax.swing.JButton getRemoveEndLineButton() {
        return removeEndLineButton;
    }

    public javax.swing.JButton getRemoveXML() {
        return removeXML;
    }

    public javax.swing.JButton getUnescapeXML() {
        return unescapeXML;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        validator.setFieldRepresentation("value", editor);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.VBox get$VBox0() {
        return $VBox0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorContent() {
        if (!allComponentsCreated) {
            return;
        }
        editorContent.add(editorScrollPane, BorderLayout.CENTER);
        editorContent.add($VBox0, BorderLayout.EAST);
    }

    protected void addChildrenToEditorScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        editorScrollPane.getViewport().add(SwingUtil.boxComponentWithJxLayer(editor));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createConvertToIso() {
        $objectMap.put("convertToIso", convertToIso = new javax.swing.JButton());
        
        convertToIso.setName("convertToIso");
        convertToIso.setText(_("vradi.editor.convertToIso"));
        convertToIso.setToolTipText(_("vradi.editor.convertToIsoToolTip"));
        convertToIso.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__convertToIso"));
    }

    protected void createConvertToUtf() {
        $objectMap.put("convertToUtf", convertToUtf = new javax.swing.JButton());
        
        convertToUtf.setName("convertToUtf");
        convertToUtf.setText(_("vradi.editor.convertToUtf"));
        convertToUtf.setToolTipText(_("vradi.editor.convertToUtfToolTip"));
        convertToUtf.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__convertToUtf"));
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new javax.swing.JTextArea());
        
        editor.setName("editor");
        editor.setColumns(15);
        editor.setLineWrap(true);
        editor.setWrapStyleWord(true);
        editor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__editor"));
    }

    @Override
    protected void createEditorContent() {
        super.createEditorContent();
        editorContent.setName("editorContent");
        ((javax.swing.JPanel) editorContent).setLayout(new BorderLayout());
    }

    protected void createEditorScrollPane() {
        $objectMap.put("editorScrollPane", editorScrollPane = new javax.swing.JScrollPane());
        
        editorScrollPane.setName("editorScrollPane");
    }

    protected void createModel() {
        $objectMap.put("model", model = new com.jurismarches.vradi.ui.offer.editors.TextEditorModel());
    }

    protected void createRemoveEndLineButton() {
        $objectMap.put("removeEndLineButton", removeEndLineButton = new javax.swing.JButton());
        
        removeEndLineButton.setName("removeEndLineButton");
        removeEndLineButton.setText(_("vradi.editor.removeEndLine"));
        removeEndLineButton.setToolTipText(_("vradi.editor.removeEndLineToolTip"));
        removeEndLineButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeEndLineButton"));
    }

    protected void createRemoveXML() {
        $objectMap.put("removeXML", removeXML = new javax.swing.JButton());
        
        removeXML.setName("removeXML");
        removeXML.setText(_("vradi.editor.removeXML"));
        removeXML.setToolTipText(_("vradi.editor.removeXMLToolTip"));
        removeXML.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeXML"));
    }

    protected void createUnescapeXML() {
        $objectMap.put("unescapeXML", unescapeXML = new javax.swing.JButton());
        
        unescapeXML.setName("unescapeXML");
        unescapeXML.setText(_("vradi.editor.unescapeXML"));
        unescapeXML.setToolTipText(_("vradi.editor.unescapeXMLToolTip"));
        unescapeXML.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__unescapeXML"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.offer.editors.TextEditorModel >(com.jurismarches.vradi.ui.offer.editors.TextEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToEditorContent();
        addChildrenToEditorScrollPane();
        // inline complete setup of $VBox0
        $VBox0.add(removeEndLineButton);
        $VBox0.add(convertToIso);
        $VBox0.add(convertToUtf);
        $VBox0.add(removeXML);
        $VBox0.add(unescapeXML);
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        editorScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        editor.setMinimumSize(new Dimension(0,56));
        // late initializer
        // register 1 validator(s)
        registerValidatorFields();validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$VradiEditor0", this);
        createModel();
        createValidator();
        createEditorScrollPane();
        createEditor();
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new jaxx.runtime.swing.VBox());
        
        $VBox0.setName("$VBox0");
        createRemoveEndLineButton();
        createConvertToIso();
        createConvertToUtf();
        createRemoveXML();
        createUnescapeXML();
        // inline creation of $VradiEditor0
        setName("$VradiEditor0");
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                editor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("value", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    jaxx.runtime.SwingUtil.setText(editor, model.getValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("value", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_END_LINE_BUTTON_ENABLED, true ,"enabled" ,"value") {
        
            @Override
            public void processDataBinding() {
                if (getValue() != null) {
                    removeEndLineButton.setEnabled(isEnabled() && getValue() != null && !getValue().isEmpty());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CONVERT_TO_ISO_ENABLED, true ,"enabled" ,"value") {
        
            @Override
            public void processDataBinding() {
                if (getValue() != null) {
                    convertToIso.setEnabled(isEnabled() && getValue() != null && !getValue().isEmpty());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CONVERT_TO_UTF_ENABLED, true ,"enabled" ,"value") {
        
            @Override
            public void processDataBinding() {
                if (getValue() != null) {
                    convertToUtf.setEnabled(isEnabled() && getValue() != null && !getValue().isEmpty());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_XML_ENABLED, true ,"enabled" ,"value") {
        
            @Override
            public void processDataBinding() {
                if (getValue() != null) {
                    removeXML.setEnabled(isEnabled() && getValue() != null && !getValue().isEmpty());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_UNESCAPE_XML_ENABLED, true ,"enabled" ,"value") {
        
            @Override
            public void processDataBinding() {
                if (getValue() != null) {
                    unescapeXML.setEnabled(isEnabled() && getValue() != null && !getValue().isEmpty());
                }
            }
        });
    }

}