/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: OfferTable.java 1876 2011-01-10 14:39:23Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.2/vradi-swing/src/main/java/com/jurismarches/vradi/ui/offer/OfferTable.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer;

import java.awt.event.MouseEvent;

import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.nuiton.widget.tooltip.FocusableTip;

/**
 * Offer table.
 * 
 * Extends default JXTable with:
 * <ul>
 *  <li>Persistent tooltip support
 * </ul>
 * 
 * @author chatellier
 * @version $Revision: 1876 $
 * 
 * Last update : $Date: 2011-01-10 15:39:23 +0100 (lun., 10 janv. 2011) $
 * By : $Author: sletellier $
 */
public class OfferTable extends JXTable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 4554858117023580350L;

    /** Single tooltip instance. */
    protected FocusableTip focusableTip;

    /*
     * @see javax.swing.JComponent#getToolTipText()
     */
    @Override
    public String getToolTipText(MouseEvent e) {

        // Get row concerned
        int row = rowAtPoint(e.getPoint());
        if (row == -1) {
            return null;
        }

        // get original text
        String text = ((OfferListTableModel)getModel()).getToolTip(convertRowIndexToModel(row));

        // Dont display toolTip if empty
        if (text == null || StringUtils.isEmpty(text.trim())) {
            return null;
        }

        // display it into persistant tooltip
        if (focusableTip == null) {
            focusableTip = new FocusableTip(this, true);
            focusableTip.setSize(600, 400);
        }

        focusableTip.toolTipRequested(e, text);

        return null;
    }
}
