/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.widget;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.models.FieldSelectModel;
import com.jurismarches.vradi.ui.admin.widget.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class FieldSelectUI extends jaxx.runtime.swing.Table implements JAXXObject, jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_INFOGENE = "infogene";
    public static final String PROPERTY_MODIFIED = "modified";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CLAZZ_COMBO_ENABLED = "clazzCombo.enabled";
    public static final String BINDING_CLAZZ_COMBO_SELECTED_ITEM = "clazzCombo.selectedItem";
    public static final String BINDING_DESC_FIELD_ENABLED = "descField.enabled";
    public static final String BINDING_DESC_FIELD_TEXT = "descField.text";
    public static final String BINDING_DOWN_VISIBLE = "down.visible";
    public static final String BINDING_NAME_FIELD_ENABLED = "nameField.enabled";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_REMOVE_VISIBLE = "remove.visible";
    public static final String BINDING_TRADUCTION_FIELD_ENABLED = "traductionField.enabled";
    public static final String BINDING_TRADUCTION_FIELD_TEXT = "traductionField.text";
    public static final String BINDING_UP_VISIBLE = "up.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1aTW/byBmmFVu27CT+WjtxnHUcZ7FwsAmdpEVbNIt2bUdKnCofsJRtUBdwR+JImoTiMMOhrcRI0Z/Qn9DeeynQW09FDz3voZeif6Eoetjrou8MRZFDDyVK2gCRrZn3ffg8z8y8MyT9p/8YUx4zbr5BnY7JfIeTNjaf7r5+/aL2Btf5I+zVGXE5ZUbwbyJn5I6MOavX7nHj1lFZpO9003f2adulDnZi2Q/LxqzH39vYa2HMufGpmlH3vJ1Kr/thx/VZiNojpUP9w//+m/u99bs/5gyj4wK7BZCyOSgrUjJZNnLE4sYSXOkE7djIaQINRpwm8L0k2vZt5HnPURu/M35rTJeNvIsYgHFjK7tkiSHzOy435hl+52OPV7AN/r464MYP67RtvvEZ8dqI1VvYM08YsojpExNZbeKYp8RqYm6WCLatMM11JWSeG5M1jBxu/HgQSpta2PbiKM9ESwQ0AxGkQTAYsii0m8IPc49SGy4QCyNOgzaxIy1ZjNoLJ8gmFgLl3PhCGYNeh+mdgrdmRXx+HTbGkD97WkY1bN+DEREEOt34oFUEFaKrOTAoUgs3VpXgKu5w2aEmhOD3xfc1tW+eg1V+nRPq9DKv69MfaNILYjUMSvyBJnG2bqMPH2Du1Cg3VhQVsnGPdtSEnA8zaFkJ3PM5p44aNmnRU9l0R23PM9ymJzjew4x1ZaxgJZrRSoyWysSRMcV8aObG1aPzi/cQuoJlezWxbAWg7P1udfmff/33X0rhWn0I117RhsZKDawhl1EXM07EpeeDhepzYu88Q+7DI6Pgyaks69B1DbFKtxvIwfWCeS3SzSfIawHE1PS//vb31d98c8HIlYxZmyKrhET8gVHgLQYuUNvquD//SjK6eDojigz8vwCj3oBojmo22DTVQLYHP/PURbC6o4ZLNcoszF4i4nCxsIL2Dvh0XeNTj2yt8I9vlyt//ir0agK4r6WGR35N/crIE8cmDpaVrVu0tJVszvWwb9GoOOnKlQHTbeZpFUrAHgoX6o/k5091lizUKbBzfOp7ZfSewsw0JjkTfixBcaxSv94qdlzkWIFr3b45i5wQMKlCPsC33P0HHV9cYU/qFr89EjRmn1Zcm/CXyMEDiEzCEmlRRj4AGWTv2qTptGXNvnUWXzmyCu1Tx+NQPj1zv/i8Wjz8KMYV8u56AZkHUItWIzBRW15Sj4hKAbPxLFjaUe6czD3FpNkS2mti8ujE5INE+G2KEw6raiQ9N/vpKRdL1aHUXArVdDOH11KQWsq4wUfTs9VPz+HB4yfDCbocCgpTh1c0KxUdioS+knLhQIK0YNuV38xTbMO2DK0rFm4g3+b7NvXwC6hnKOC4bNFjh/IWSD2mznFddJ/nBKrbUEFKDJavO2D2TwCV45Zkv3C2Bbu/yDTBYH/row55UnQNAr0gFiuYC3M+kCeSzAYRgmfaDuwqDqlzY6IUXXxFvbgM1jOYEf0l6M7OYi3BwqSNBmZl4nGVz4uIzw0NnyhNz2xZRFZa9PRFGCcOXv1JTvVIXgtIInmuMKE0NkjTDwc+znIfJloQdSAKqJEPYmHCcqi8VeJWJd5GOh5MNzeSeksnVYnXy10JB2I/Hptd8GpyVGxaR8kpkhRbgLOX49mI46TeVLhQ53WdziBIL3AhFFiGk62PmgNnHGibxo7YrWDv3ju7iep17PKyvMT214JeYNUT4IOZCaf0bh/8FvRs3759Z3OrwY5Lh1u3Pyat6o5lwNlssIQ30+T+T5y7oll15po+W50F2gnfi9UbtJQ0qHQ4yKL892QRdo4f7w20yH+rzqZXWsdEVAbH/LfZHfPfZnTs1S8yONaVeEVh1fBtG24eMRY6TohH5CFp6ewm8V45Fq5TWI/Y2hYWxS14mbBgNo6jurCecj3Vhk2dDVHwAB9KvcDsPqwpvBzK2kjjxOJZfyOeJ4xYgPvWE3w33Y5PUy+rGvK5dl4kwPW2fBLa8jyGnr2iLioMcYck9rfXCcmTQYgqc+UciCrvmk6eCNNLuhhKKkLIiAcHMEMV8qzPwQGC+x0coDs7i6UYi8AQTyWyGxG5kiASxOupzImI3QAwO5uFOBvxkCaVS/bTVEEyEWDZeSzGeNRtIg/jiT17FFPme1T2JehoxjQZFU894nwej8bnco/PY4GZnc5yYu5W37vpB99hGF3qMRpuGn8SI9Rp2xXOMGqfKw2jMFrqMXod4o42j+C2jfuJxVUZdx5VJOhoPvEW9pDPkpyq4/pUDXFHm94YrmerlIojr/uiAMvOYzXJQ1eFRlz80WIbktSVGCnSdinjxY74VFkdjOKRPP8fxDCzs9pIYQUb5XlyxdEsm5VD+H0RC76kujY0scC37MRupBFjmMAprqMyOxxj3z0MAEc7iwTXjFPB6VNLtPY5i4h7nFEPd1oe6uEuCOl3uBMR/Q93MiJdxsVQxjhSPMIT26OXlBKE9JMiIjJIEWEDpFQgJLuUJYUFqsmn2IlTmaJlqhujfXgRh1HVrOvUyLg+RwUhZ1fEZHgKqNlrLFzzm6mbxyPRmx04MeawM6fSlshi785wS1ho0Lrvqa9VFL9n5EPSKqolLVfvIt/5hD/pLYd5Rm2bnmBWDB9V9H9DE43TRjRONWq9D8YppJBSC8LuQXJz3Mjb3Rcl62cOPt3co53gzcm2kFZD7M7mPXGfG7JZjth0A/QUpru92Ydz6cvgxdEm4pyRms/xz84BT4jPqxkwoydCl7+0EEebNajQxGmmQK4PhITm3FXxcWNshDU9wkYmhI0+HDbHVjEEQoqKrbFVfDa2iiEQUlR8PraK7SyvSeRfRIwJMsMwnD0YZmPiXAzeY2PrgOP2mFiTpC7/IiAN44ssK7j72G0sGJH8yz4IZiaEX4+N0I/DvbE5CIT/A+yBnwJHJQAA";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.widget.FieldSelectUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.ui.admin.models.FieldSelectModel bean;
    protected javax.swing.JComboBox clazzCombo;
    protected javax.swing.JTextField descField;
    protected javax.swing.JButton down;
    protected java.lang.Boolean infogene;
    protected java.lang.Boolean modified;
    protected javax.swing.JTextField nameField;
    protected javax.swing.JButton remove;
    protected FieldSelectUI requestSelectUI = this;
    protected javax.swing.JTextField traductionField;
    protected javax.swing.JButton up;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.admin.models.FieldSelectModel > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel contentPane;
    
    
    public void updateBean(FieldSelectModel model) {
        bean.update(model);
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public void setContentPane(JPanel contentPane){
        this.contentPane = contentPane;
    }
    
    void $afterCompleteSetup() {
        getContextValue(SwingValidatorMessageTableModel.class,"errorTable").registerValidator(validator);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FieldSelectUI() {
        $initialize();
    }

    public FieldSelectUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.admin.models.FieldSelectModel > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__clazzCombo(java.awt.event.ActionEvent event) {
        bean.setType((FieldTypeEnum) clazzCombo.getSelectedItem());                                           setModified(true);
    }

    public void doActionPerformed__on__down(java.awt.event.ActionEvent event) {
        bean.setUpOrDown(false);                                         log.debug(bean.getNameValue() + " : " + bean.isUpOrDown());                                         setModified(null);
    }

    public void doActionPerformed__on__remove(java.awt.event.ActionEvent event) {
        bean.setUpOrDown(null);                                         setModified(null);
    }

    public void doActionPerformed__on__up(java.awt.event.ActionEvent event) {
        bean.setUpOrDown(true);                                         log.debug(bean.getNameValue() + " : " + bean.isUpOrDown());                                         setModified(null);
    }

    public void doKeyReleased__on__descField(java.awt.event.KeyEvent event) {
        bean.setDescValue(descField.getText());                                        setModified(true);
    }

    public void doKeyReleased__on__nameField(java.awt.event.KeyEvent event) {
        bean.setNameValue(nameField.getText().trim());                                        setModified(true);
    }

    public void doKeyReleased__on__traductionField(java.awt.event.KeyEvent event) {
        bean.setTraduction(traductionField.getText().trim());                                        setModified(true);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.ui.admin.models.FieldSelectModel getBean() {
        return bean;
    }

    public javax.swing.JComboBox getClazzCombo() {
        return clazzCombo;
    }

    public javax.swing.JTextField getDescField() {
        return descField;
    }

    public javax.swing.JButton getDown() {
        return down;
    }

    public java.lang.Boolean getInfogene() {
        return infogene;
    }

    public java.lang.Boolean getModified() {
        return modified;
    }

    public javax.swing.JTextField getNameField() {
        return nameField;
    }

    public javax.swing.JButton getRemove() {
        return remove;
    }

    public javax.swing.JTextField getTraductionField() {
        return traductionField;
    }

    public javax.swing.JButton getUp() {
        return up;
    }

    public java.lang.Boolean isInfogene() {
        return infogene !=null && infogene;
    }

    public java.lang.Boolean isModified() {
        return modified !=null && modified;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setInfogene(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.infogene;
        this.infogene = newValue;
        firePropertyChange(PROPERTY_INFOGENE, oldValue, newValue);
    }

    public void setModified(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.modified;
        this.modified = newValue;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        validator.setFieldRepresentation("descValue", descField);
        validator.setFieldRepresentation("nameValue", nameField);
        validator.setFieldRepresentation("type", clazzCombo);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToRequestSelectUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(traductionField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel2, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(SwingUtil.boxComponentWithJxLayer(descField), new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel3, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(SwingUtil.boxComponentWithJxLayer(clazzCombo), new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(up, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(down, new GridBagConstraints(9, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(remove, new GridBagConstraints(10, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setBean(bean);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new com.jurismarches.vradi.ui.admin.models.FieldSelectModel());
    }

    protected void createClazzCombo() {
        $objectMap.put("clazzCombo", clazzCombo = new javax.swing.JComboBox());
        
        clazzCombo.setName("clazzCombo");
        clazzCombo.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clazzCombo"));
    }

    protected void createDescField() {
        $objectMap.put("descField", descField = new javax.swing.JTextField());
        
        descField.setName("descField");
        descField.setColumns(15);
        descField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__descField"));
    }

    protected void createDown() {
        $objectMap.put("down", down = new javax.swing.JButton());
        
        down.setName("down");
        down.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__down"));
    }

    protected void createInfogene() {
        $objectMap.put("infogene", infogene = false);
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new javax.swing.JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new javax.swing.JButton());
        
        remove.setName("remove");
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createTraductionField() {
        $objectMap.put("traductionField", traductionField = new javax.swing.JTextField());
        
        traductionField.setName("traductionField");
        traductionField.setColumns(15);
        traductionField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__traductionField"));
    }

    protected void createUp() {
        $objectMap.put("up", up = new javax.swing.JButton());
        
        up.setName("up");
        up.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__up"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.admin.models.FieldSelectModel >(com.jurismarches.vradi.ui.admin.models.FieldSelectModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToRequestSelectUI();
        addChildrenToValidator();
        
        // apply 11 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        clazzCombo.setModel(getHandler().getTypesModel());
        clazzCombo.setRenderer(UIHelper.getTranslationListCellRenderer());
        up.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("arrowUp"));
        down.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("arrowDown"));
        remove.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        // late initializer
        // register 1 validator(s)
        registerValidatorFields();validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("requestSelectUI", this);
        createBean();
        createModified();
        createInfogene();
        createValidator();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminField.name"));
        createNameField();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminField.lbl"));
        createTraductionField();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminField.desc"));
        createDescField();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminField.type"));
        createClazzCombo();
        createUp();
        createDown();
        createRemove();
        // inline creation of requestSelectUI
        setName("requestSelectUI");
        
        // registers 11 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 11 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NAME_FIELD_ENABLED, true ,"infogene") {
        
            @Override
            public void processDataBinding() {
                nameField.setEnabled(!isInfogene());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("nameValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(nameField, bean.getNameValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("nameValue", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TRADUCTION_FIELD_ENABLED, true ,"infogene") {
        
            @Override
            public void processDataBinding() {
                traductionField.setEnabled(!isInfogene());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRADUCTION_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("traduction", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(traductionField, bean.getTraduction());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("traduction", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DESC_FIELD_ENABLED, true ,"infogene") {
        
            @Override
            public void processDataBinding() {
                descField.setEnabled(!isInfogene());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESC_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("descValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(descField, bean.getDescValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("descValue", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLAZZ_COMBO_ENABLED, true ,"infogene") {
        
            @Override
            public void processDataBinding() {
                clazzCombo.setEnabled(!isInfogene());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLAZZ_COMBO_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("type", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    clazzCombo.setSelectedItem(bean.getType());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("type", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_UP_VISIBLE, true ,"infogene") {
        
            @Override
            public void processDataBinding() {
                up.setVisible(!isInfogene());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DOWN_VISIBLE, true ,"infogene") {
        
            @Override
            public void processDataBinding() {
                down.setVisible(!isInfogene());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_VISIBLE, true ,"infogene") {
        
            @Override
            public void processDataBinding() {
                remove.setVisible(!isInfogene());
            }
        });
    }

}