/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.internal.util.logging;

import com.arjuna.common.internal.util.logging.LogInterface;
import com.arjuna.common.util.logging.Logi18n;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Logi18nImpl
implements Logi18n {
    private ResourceBundle m_defaultResourceBundle = null;
    private ResourceBundle[] m_extraResourceBundles = null;
    private long m_debugLevel = 0L;
    private long m_visLevel = -1L;
    private long m_facLevel = -1L;
    private final LogInterface m_logInterface;

    public Logi18nImpl(LogInterface logInterface, String resBundle, long dl, long vl, long fl) {
        this.m_logInterface = logInterface;
        this.setLevels(dl, vl, fl);
        this.addResourceBundle(resBundle);
    }

    @Override
    public synchronized void addResourceBundle(String bundleName) {
        try {
            if (this.m_defaultResourceBundle == null) {
                this.m_defaultResourceBundle = PropertyResourceBundle.getBundle(bundleName, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
            } else if (this.m_extraResourceBundles == null) {
                this.m_extraResourceBundles = new ResourceBundle[]{PropertyResourceBundle.getBundle(bundleName, Locale.getDefault(), Thread.currentThread().getContextClassLoader())};
            } else {
                ResourceBundle[] oldExtraResBundles = this.m_extraResourceBundles;
                this.m_extraResourceBundles = new ResourceBundle[oldExtraResBundles.length + 1];
                System.arraycopy(oldExtraResBundles, 0, this.m_extraResourceBundles, 0, oldExtraResBundles.length);
                this.m_extraResourceBundles[oldExtraResBundles.length] = PropertyResourceBundle.getBundle(bundleName, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
            }
        }
        catch (MissingResourceException mre) {
            System.err.println("resource bundle " + mre.getClassName() + " not found!");
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugAllowed(-1L, -1L, -1L);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.m_logInterface.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.m_logInterface.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.m_logInterface.isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.m_logInterface.isFatalEnabled();
    }

    private void setLevels(long dl, long vl, long fl) {
        this.m_debugLevel = dl;
        this.m_visLevel = vl;
        this.m_facLevel = fl;
    }

    private boolean debugAllowed(long dLevel, long vLevel, long fLevel) {
        return (dLevel & this.m_debugLevel) != 0L && (vLevel & this.m_visLevel) != 0L && (fLevel & this.m_facLevel) != 0L && this.m_logInterface.isDebugEnabled();
    }

    @Override
    public void debug(long dl, long vl, long fl, String key, Object[] params) {
        if (this.debugAllowed(dl, vl, fl)) {
            this.debug(key, params);
        }
    }

    @Override
    public void debug(long dl, long vl, long fl, String key) {
        if (this.debugAllowed(dl, vl, fl)) {
            this.debug(key);
        }
    }

    @Override
    public void debug(long dl, long vl, long fl, String key, Throwable throwable) {
        if (this.debugAllowed(dl, vl, fl)) {
            this.debug(key, throwable);
        }
    }

    @Override
    public void debug(long dl, long vl, long fl, String key, Object[] params, Throwable throwable) {
        if (this.debugAllowed(dl, vl, fl)) {
            this.debug(key, params, throwable);
        }
    }

    @Override
    public String getString(String key) {
        try {
            return this.getResourceBundleString(key);
        }
        catch (MissingResourceException mre) {
            return mre.getLocalizedMessage() + ": [key='" + key + "']";
        }
    }

    @Override
    public String getString(String key, Object[] params) {
        try {
            String pattern = this.getResourceBundleString(key);
            return MessageFormat.format(pattern, params);
        }
        catch (MissingResourceException mre) {
            StringBuffer sb = new StringBuffer();
            for (Object param : params) {
                sb.append(param);
                sb.append(", ");
            }
            return mre.getLocalizedMessage() + ": [key='" + key + "']" + sb.toString();
        }
    }

    synchronized String getResourceBundleString(String key) throws MissingResourceException {
        String resource;
        block7: {
            resource = null;
            if (this.m_defaultResourceBundle == null) {
                throw new MissingResourceException("no default resource bundle set for this logger", null, null);
            }
            try {
                resource = this.m_defaultResourceBundle.getString(key);
            }
            catch (MissingResourceException mre) {
                if (this.m_extraResourceBundles == null) {
                    throw mre;
                }
                for (ResourceBundle bundle : this.m_extraResourceBundles) {
                    try {
                        resource = bundle.getString(key);
                    }
                    catch (MissingResourceException mre2) {
                        mre = mre2;
                    }
                }
                if (resource != null) break block7;
                throw mre;
            }
        }
        return resource;
    }

    @Override
    public void debug(String key) {
        if (!this.isDebugEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.debug(message);
    }

    @Override
    public void debug(String key, Throwable throwable) {
        if (!this.isDebugEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.debug(message, throwable);
    }

    @Override
    public void debug(String key, Object[] params) {
        if (!this.isDebugEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.debug(message);
    }

    @Override
    public void debug(String key, Object[] params, Throwable throwable) {
        if (!this.isDebugEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.debug(message, throwable);
    }

    @Override
    public void info(String key) {
        if (!this.isInfoEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.info(message);
    }

    @Override
    public void info(String key, Throwable throwable) {
        if (!this.isInfoEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.info(message, throwable);
    }

    @Override
    public void info(String key, Object[] params) {
        if (!this.isInfoEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.info(message);
    }

    @Override
    public void info(String key, Object[] params, Throwable throwable) {
        if (!this.isInfoEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.info(message, throwable);
    }

    @Override
    public void warn(String key) {
        if (!this.isWarnEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.warn(message);
    }

    @Override
    public void warn(String key, Throwable throwable) {
        if (!this.isWarnEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.warn(message, throwable);
    }

    @Override
    public void warn(String key, Object[] params) {
        if (!this.isWarnEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.warn(message);
    }

    @Override
    public void warn(String key, Object[] params, Throwable throwable) {
        if (!this.isWarnEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.warn(message, throwable);
    }

    @Override
    public void error(String key) {
        if (!this.isErrorEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.error(message);
    }

    @Override
    public void error(String key, Throwable throwable) {
        if (!this.isErrorEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.error(message, throwable);
    }

    @Override
    public void error(String key, Object[] params) {
        if (!this.isErrorEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.error(message);
    }

    @Override
    public void error(String key, Object[] params, Throwable throwable) {
        if (!this.isErrorEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.error(message, throwable);
    }

    @Override
    public void fatal(String key) {
        if (!this.isFatalEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.fatal(message);
    }

    @Override
    public void fatal(String key, Throwable throwable) {
        if (!this.isFatalEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.fatal(message, throwable);
    }

    @Override
    public void fatal(String key, Object[] params) {
        if (!this.isFatalEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.fatal(message);
    }

    @Override
    public void fatal(String key, Object[] params, Throwable throwable) {
        if (!this.isFatalEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.fatal(message, throwable);
    }

    private String evalResourceBundle(String key) {
        return this.getString(key);
    }

    private String evalResourceBundle(String key, Object[] params) {
        return this.getString(key, params);
    }
}

