/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.thesaurus.helpers;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThesaurusSelectionManager {
    private static final Log log = LogFactory.getLog(ThesaurusSelectionManager.class);
    protected JList propositionList;
    protected PropositionSelectionModel propositionSelectionModel;
    protected ThesaurusListener propositionListener;
    protected ThesaurusTreeHelper rootHelper;
    protected RootThesaurusListener rootListener;
    protected Map<ThesaurusTreeHelper, ThesaurusListener> helpers;
    protected Form form;
    protected boolean isRootListening = true;

    public ThesaurusSelectionManager(JList propositionList, Form form) {
        this.form = form;
        this.propositionList = propositionList;
        this.propositionSelectionModel = new PropositionSelectionModel();
        this.propositionList.setSelectionModel(this.propositionSelectionModel);
        this.helpers = new HashMap<ThesaurusTreeHelper, ThesaurusListener>();
        this.propositionListener = new ThesaurusListener();
        propositionList.getSelectionModel().addListSelectionListener(this.propositionListener);
    }

    public VradiDataProvider getDataProvider() {
        return this.rootHelper.getDataProvider();
    }

    public Form getForm() {
        return this.form;
    }

    public ThesaurusTreeHelper getRootHelper() {
        return this.rootHelper;
    }

    public List<ThesaurusTreeHelper> getHelpers() {
        return new ArrayList<ThesaurusTreeHelper>(this.helpers.keySet());
    }

    public void registerRootTreeHelper(ThesaurusTreeHelper rootHelper, JTree tree) {
        this.rootHelper = rootHelper;
        this.useMultipleSelectionMode(tree);
        this.rootListener = new RootThesaurusListener();
        rootHelper.setUI(tree, true, false, this.rootListener);
        this.selectRootThesaurus(rootHelper);
    }

    public void registerTreeHelper(ThesaurusTreeHelper helper, JTree tree) {
        this.registerListener(helper, tree);
        this.selectThesaurus(helper);
    }

    protected void registerListener(ThesaurusTreeHelper helper, JTree tree) {
        this.useMultipleSelectionMode(tree);
        ThesaurusListener listener = new ThesaurusListener();
        this.helpers.put(helper, listener);
        helper.setUI(tree, true, false, listener);
    }

    protected void useMultipleSelectionMode(JTree tree) {
        tree.getSelectionModel().setSelectionMode(4);
    }

    protected void desactiveRootListener() {
        this.isRootListening = false;
    }

    protected void activeRootListener() {
        this.isRootListening = true;
    }

    protected void desactiveListener(ThesaurusTreeHelper helper) {
        this.helpers.get(helper).desactiveListener();
    }

    protected void activeListener(ThesaurusTreeHelper helper) {
        this.helpers.get(helper).activeListener();
    }

    protected void selectRootThesaurus(ThesaurusTreeHelper helper) {
        try {
            List thesauruses = VradiService.getVradiDataService().getThesaurusAttachedToForm(this.form);
            if (thesauruses != null) {
                this.desactiveRootListener();
                helper.tryToSelect(thesauruses);
                this.activeRootListener();
                this.propositionSelectionModel.tryToSelectObjects(thesauruses);
            }
        }
        catch (VradiException ex) {
            throw new RuntimeException("Can't get form thesaurus", ex);
        }
    }

    protected void selectThesaurus(ThesaurusTreeHelper helper) {
        this.desactiveListener(helper);
        List nodes = this.rootHelper.getSelectedNodes();
        List<String> thesaurusIds = this.extractIds(nodes);
        helper.tryToSelect(thesaurusIds);
        this.activeListener(helper);
    }

    protected List<String> extractIds(List<VradiTreeNode> nodes) {
        ArrayList<String> ids = new ArrayList<String>();
        for (VradiTreeNode node : nodes) {
            ids.add(node.getId());
        }
        return ids;
    }

    public void tryToSelect(Thesaurus thesaurus) {
        if (thesaurus != null) {
            this.rootHelper.tryToSelect(thesaurus);
        }
    }

    public void tryToUnSelect(Thesaurus thesaurus) {
        if (thesaurus != null) {
            this.rootHelper.tryToUnselect(thesaurus);
        }
    }

    protected class PropositionSelectionModel
    extends DefaultListSelectionModel {
        protected PropositionSelectionModel() {
        }

        protected void tryToSelect(List<String> thesaurusId) {
            List<Thesaurus> thesauruss = ThesaurusDataHelper.restoreThesaurus(thesaurusId);
            this.tryToSelectObjects(thesauruss);
        }

        protected void tryToSelectObjects(List<Thesaurus> thesauruses) {
            for (Thesaurus thesaurus : thesauruses) {
                int toSelect = ((DefaultListModel)ThesaurusSelectionManager.this.propositionList.getModel()).indexOf(thesaurus);
                super.addSelectionInterval(toSelect, toSelect);
            }
        }

        protected void tryToUnSelect(List<String> thesaurusId) {
            List<Thesaurus> thesauruss = ThesaurusDataHelper.restoreThesaurus(thesaurusId);
            for (Thesaurus thesaurus : thesauruss) {
                int toSelect = ((DefaultListModel)ThesaurusSelectionManager.this.propositionList.getModel()).indexOf(thesaurus);
                super.removeSelectionInterval(toSelect, toSelect);
            }
        }
    }

    protected class ThesaurusListener
    implements TreeSelectionListener,
    ListSelectionListener {
        protected List<Object> oldsPropositionsSelected;
        protected boolean isThesaurusListening = true;

        protected ThesaurusListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (!this.isThesaurusListening) {
                return;
            }
            TreePath[] paths = e.getPaths();
            ArrayList<String> toAdd = new ArrayList<String>();
            ArrayList<String> toRemove = new ArrayList<String>();
            for (TreePath path : paths) {
                Thesaurus thesaurus;
                VradiTreeNode node = (VradiTreeNode)((Object)path.getLastPathComponent());
                String id = node.getId();
                if (e.isAddedPath(path)) {
                    if (log.isDebugEnabled()) {
                        thesaurus = ThesaurusDataHelper.restoreThesaurus(id);
                        log.debug((Object)("[Listener] try to add thesaurus : " + thesaurus.getName()));
                    }
                    toAdd.add(id);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    thesaurus = ThesaurusDataHelper.restoreThesaurus(id);
                    log.debug((Object)("[Listener] try to remove thesaurus : " + thesaurus.getName()));
                }
                toRemove.add(id);
            }
            ThesaurusSelectionManager.this.rootHelper.tryToSelect((List<String>)toAdd);
            ThesaurusSelectionManager.this.rootHelper.tryToUnselect((List<String>)toRemove);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Thesaurus proposition;
            if (!this.isThesaurusListening) {
                return;
            }
            List<Object> newPropositionsSelected = Arrays.asList(ThesaurusSelectionManager.this.propositionList.getSelectedValues());
            ArrayList<String> idsToAdd = new ArrayList<String>();
            ArrayList<String> idsToRemove = new ArrayList<String>();
            for (Object o : newPropositionsSelected) {
                if (this.oldsPropositionsSelected != null && this.oldsPropositionsSelected.contains(o)) continue;
                proposition = (Thesaurus)o;
                idsToAdd.add(proposition.getWikittyId());
            }
            if (this.oldsPropositionsSelected != null) {
                for (Object o : this.oldsPropositionsSelected) {
                    if (newPropositionsSelected.contains(o)) continue;
                    proposition = (Thesaurus)o;
                    idsToRemove.add(proposition.getWikittyId());
                }
            }
            ThesaurusSelectionManager.this.rootHelper.tryToSelect((List<String>)idsToAdd);
            ThesaurusSelectionManager.this.rootHelper.tryToUnselect((List<String>)idsToRemove);
            this.oldsPropositionsSelected = newPropositionsSelected;
        }

        public void desactiveListener() {
            this.isThesaurusListening = false;
        }

        public void activeListener() {
            this.isThesaurusListening = true;
        }
    }

    protected class RootThesaurusListener
    implements TreeSelectionListener {
        protected RootThesaurusListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (!ThesaurusSelectionManager.this.isRootListening) {
                return;
            }
            TreePath[] paths = e.getPaths();
            ArrayList<String> toAdd = new ArrayList<String>();
            ArrayList<String> toRemove = new ArrayList<String>();
            for (TreePath path : paths) {
                Thesaurus thesaurus;
                VradiTreeNode node = (VradiTreeNode)((Object)path.getLastPathComponent());
                String id = node.getId();
                if (e.isAddedPath(path)) {
                    if (log.isDebugEnabled()) {
                        thesaurus = ThesaurusDataHelper.restoreThesaurus(id);
                        log.debug((Object)("[Root listener] try to add thesaurus : " + thesaurus.getName()));
                    }
                    toAdd.add(id);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    thesaurus = ThesaurusDataHelper.restoreThesaurus(id);
                    log.debug((Object)("[Root listener] try to remove thesaurus : " + thesaurus.getName()));
                }
                toRemove.add(id);
            }
            for (ThesaurusTreeHelper helper : ThesaurusSelectionManager.this.helpers.keySet()) {
                VradiTreeNode rootNode;
                if (log.isDebugEnabled() && Thesaurus.class.equals((Object)(rootNode = helper.getRootNode()).getInternalClass())) {
                    Thesaurus rootThesaurus = ThesaurusDataHelper.restoreThesaurus(rootNode.getId());
                    log.debug((Object)("[Root listener] Apply selection for helper with root " + rootThesaurus.getName()));
                }
                ThesaurusSelectionManager.this.desactiveListener(helper);
                helper.tryToSelect((List<String>)toAdd);
                helper.tryToUnselect((List<String>)toRemove);
                ThesaurusSelectionManager.this.activeListener(helper);
            }
            ThesaurusSelectionManager.this.propositionListener.desactiveListener();
            ThesaurusSelectionManager.this.propositionSelectionModel.tryToSelect(toAdd);
            ThesaurusSelectionManager.this.propositionSelectionModel.tryToUnSelect(toRemove);
            ThesaurusSelectionManager.this.propositionListener.activeListener();
        }
    }
}

