/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import net.sf.saxon.trans.XPathException;
import org.webharvest.exception.ScriptException;
import org.webharvest.gui.FindReplaceDialog;
import org.webharvest.gui.GuiUtils;
import org.webharvest.gui.ResourceManager;
import org.webharvest.gui.TreeNodeInfo;
import org.webharvest.gui.XmlEditorScrollPane;
import org.webharvest.gui.XmlTextPane;
import org.webharvest.gui.component.CommonButton;
import org.webharvest.gui.component.DropDownButton;
import org.webharvest.gui.component.DropDownButtonListener;
import org.webharvest.gui.component.EditableComboBox;
import org.webharvest.gui.component.MenuElements;
import org.webharvest.gui.component.ProportionalSplitPane;
import org.webharvest.gui.component.SmallButton;
import org.webharvest.gui.component.WHCheckBox;
import org.webharvest.gui.component.WHScrollPane;
import org.webharvest.runtime.RuntimeConfig;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.templaters.BaseTemplater;
import org.webharvest.runtime.variables.ListVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;
import org.webharvest.utils.XmlUtil;
import org.webharvest.utils.XmlValidator;
import org.xml.sax.InputSource;

public class ViewerFrame
extends JFrame
implements DropDownButtonListener,
ActionListener {
    private static final int FIND_OPEN = 0;
    private static final int FIND_NEXT = 1;
    private static final int FIND_PREVIOUS = 2;
    public static final int TEXT_VIEW = 0;
    public static final int XML_VIEW = 1;
    public static final int HTML_VIEW = 2;
    public static final int IMAGE_VIEW = 3;
    public static final int LIST_VIEW = 4;
    private FindReplaceDialog findDialog;
    private boolean[] refreshed = new boolean[5];
    private String propertyName;
    private Object value;
    private TreeNodeInfo nodeInfo;
    private int currentView = 0;
    private JPanel cardPanel;
    private JTextArea textArea;
    private JEditorPane htmlPane;
    private XmlTextPane xmlPane;
    private JPanel imagePanel;
    private JLabel imageLabel;
    private int zoomFactor = 100;
    private JLabel zoomFactorLabel;
    private JTable listTable;
    private JCheckBox keepSyncCheckBox;
    private JCheckBox wrapTextCheckBox;
    private JButton findButton;
    private JButton zoomInButton;
    private JButton zoomOutButton;
    private JButton xmlValidateButton;
    private JButton xmlPrettyPrintButton;
    private RuntimeConfig runtimeConfig = new RuntimeConfig();
    private JEditorPane xpathResultPane;

    public ViewerFrame(final Scraper scraper, String propertyName, Object value, final TreeNodeInfo nodeInfo, int viewIndex) {
        if (propertyName == null) {
            this.setTitle("Runtime Value Viewer");
        } else {
            String elementName = nodeInfo.getElementDef().getShortElementName();
            this.setTitle(elementName + "->" + propertyName);
        }
        this.setIconImage(((ImageIcon)ResourceManager.VIEW_ICON).getImage());
        this.propertyName = propertyName;
        this.value = value;
        this.nodeInfo = nodeInfo;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (nodeInfo != null) {
                    nodeInfo.removeSynchronizedView(ViewerFrame.this);
                }
                super.windowClosing(e);
                ViewerFrame.this.nodeInfo = null;
                ViewerFrame.this.value = null;
                ViewerFrame.this.dispose();
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        toolBar.setLayout(new FlowLayout(0, 1, 0));
        toolBar.setFloatable(false);
        if (scraper != null) {
            ScraperContext context = scraper.getContext();
            if (propertyName == null) {
                final EditableComboBox variablesComboBox = new EditableComboBox(20){

                    @Override
                    protected void execute(Object value) {
                        if (value != null) {
                            try {
                                ViewerFrame.this.value = BaseTemplater.execute("${" + value + "}", scraper.getScriptEngine());
                            }
                            catch (ScriptException e) {
                                ViewerFrame.this.value = "Error evaluating \"" + value + "\"!";
                            }
                            for (int i = 0; i < ViewerFrame.this.refreshed.length; ++i) {
                                ((ViewerFrame)ViewerFrame.this).refreshed[i] = false;
                            }
                            ViewerFrame.this.refresh(ViewerFrame.this.currentView);
                        }
                    }
                };
                if (context != null) {
                    Iterator iterator = new TreeSet(context.keySet()).iterator();
                    while (iterator.hasNext()) {
                        variablesComboBox.addItem(iterator.next());
                    }
                }
                SmallButton goButton = new SmallButton("Eval");
                goButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        variablesComboBox.onValue();
                    }
                });
                variablesComboBox.getEditor().setItem("");
                toolBar.add(new JLabel("Expression:"));
                toolBar.add(variablesComboBox);
                toolBar.add(goButton);
                toolBar.addSeparator(new Dimension(10, 0));
            }
            int scraperStatus = scraper.getStatus();
            if (propertyName != null && scraperStatus == 1 || scraperStatus == 2) {
                this.keepSyncCheckBox = new WHCheckBox("Synchronized");
                this.keepSyncCheckBox.addActionListener(this);
                toolBar.add(this.keepSyncCheckBox);
                toolBar.addSeparator(new Dimension(10, 0));
            }
        }
        DropDownButton viewTypeButton = new DropDownButton();
        viewTypeButton.addMenuItem(new MenuElements.MenuItem("Text    ", ResourceManager.TEXTTYPE_ICON));
        viewTypeButton.addMenuItem(new MenuElements.MenuItem("XML    ", ResourceManager.XMLTYPE_ICON));
        viewTypeButton.addMenuItem(new MenuElements.MenuItem("HTML    ", ResourceManager.HTMLTYPE_ICON));
        viewTypeButton.addMenuItem(new MenuElements.MenuItem("Image    ", ResourceManager.IMAGETYPE_ICON));
        viewTypeButton.addMenuItem(new MenuElements.MenuItem("List    ", ResourceManager.LISTTYPE_ICON));
        viewTypeButton.changeSelectedTo(viewIndex);
        viewTypeButton.addListener(this);
        toolBar.add(new JLabel(" View as: "));
        toolBar.add(viewTypeButton);
        MyAction findTextAction = new MyAction("Find", ResourceManager.FIND_ICON, "Find text", KeyStroke.getKeyStroke(70, 2)){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.findText(0);
            }
        };
        MyAction findNextAction = new MyAction("Find Next", null, "Find next occurence", KeyStroke.getKeyStroke(114, 0)){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.findText(1);
            }
        };
        MyAction findPrevAction = new MyAction("Find Previous", null, "Find previous occurence", KeyStroke.getKeyStroke(114, 64)){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.findText(2);
            }
        };
        MyAction zoomInAction = new MyAction("Zoom In", ResourceManager.ZOOMIN_ICON, "Zoom Image In", KeyStroke.getKeyStroke(521, 0)){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.zoom(true);
            }
        };
        MyAction zoomOutAction = new MyAction("Zoom Out", ResourceManager.ZOOMOUT_ICON, "Zoom Image Out", KeyStroke.getKeyStroke(45, 0)){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.zoom(false);
            }
        };
        this.findButton = new CommonButton(findTextAction);
        this.findButton.registerKeyboardAction(findTextAction, KeyStroke.getKeyStroke(70, 2), 2);
        this.findButton.registerKeyboardAction(findNextAction, KeyStroke.getKeyStroke(114, 0), 2);
        this.findButton.registerKeyboardAction(findPrevAction, KeyStroke.getKeyStroke(114, 1), 2);
        this.wrapTextCheckBox = new WHCheckBox("Wrap Text");
        this.wrapTextCheckBox.addActionListener(this);
        toolBar.add(this.wrapTextCheckBox);
        this.zoomInButton = new CommonButton(zoomInAction);
        this.zoomInButton.registerKeyboardAction(zoomInAction, KeyStroke.getKeyStroke(107, 0), 2);
        this.zoomOutButton = new CommonButton(zoomOutAction);
        this.zoomOutButton.registerKeyboardAction(zoomOutAction, KeyStroke.getKeyStroke(109, 0), 2);
        this.zoomFactorLabel = new JLabel();
        this.xmlValidateButton = new CommonButton("Validate", ResourceManager.VALIDATE_ICON);
        this.xmlValidateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.validateXml(true);
            }
        });
        this.xmlPrettyPrintButton = new CommonButton("Pretty-print", ResourceManager.PRETTY_PRINT_ICON);
        this.xmlPrettyPrintButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewerFrame.this.prettyPrintXml();
            }
        });
        toolBar.addSeparator(new Dimension(10, 0));
        toolBar.add(this.findButton);
        toolBar.add(this.xmlValidateButton);
        toolBar.add(this.xmlPrettyPrintButton);
        toolBar.add(this.zoomInButton);
        toolBar.add(this.zoomOutButton);
        toolBar.add(this.zoomFactorLabel);
        contentPane.add((Component)toolBar, "North");
        this.cardPanel = new JPanel(new CardLayout());
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.cardPanel.add((Component)new WHScrollPane(this.textArea), String.valueOf(0));
        this.xmlPane = new XmlTextPane();
        this.xmlPane.setEditable(false);
        JPanel xpathPanel = new JPanel(new BorderLayout());
        JToolBar xpathToolbar = new JToolBar();
        final EditableComboBox xpathComboBox = new EditableComboBox(50){

            @Override
            protected void execute(Object value) {
                ViewerFrame.this.evaluateXPath((String)this.getEditor().getItem());
            }
        };
        SmallButton xpathEvalButton = new SmallButton("Evaluate");
        xpathEvalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String expression = (String)xpathComboBox.getSelectedItem();
                if (!CommonUtil.isEmptyString(expression)) {
                    xpathComboBox.removeItem(expression);
                    xpathComboBox.insertItemAt(expression, 0);
                    xpathComboBox.setSelectedItem(expression);
                    ViewerFrame.this.evaluateXPath(expression);
                }
            }
        });
        xpathToolbar.setFloatable(false);
        xpathToolbar.add(new JLabel(" XPath expression: "));
        xpathToolbar.add(xpathComboBox);
        xpathToolbar.add(xpathEvalButton);
        this.xpathResultPane = new JEditorPane();
        this.xpathResultPane.setEditable(false);
        this.xpathResultPane.setContentType("text/html");
        this.xpathResultPane.setEditorKit(new HTMLEditorKit());
        xpathPanel.add((Component)xpathToolbar, "North");
        xpathPanel.add((Component)new WHScrollPane(this.xpathResultPane), "Center");
        ProportionalSplitPane splitPane = new ProportionalSplitPane(0);
        splitPane.setResizeWeight(1.0);
        splitPane.setBorder(null);
        splitPane.setTopComponent(new XmlEditorScrollPane(this.xmlPane, false));
        splitPane.setBottomComponent(xpathPanel);
        ((JSplitPane)splitPane).setDividerLocation(0.75);
        splitPane.setDividerSize(7);
        this.cardPanel.add((Component)splitPane, String.valueOf(1));
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        this.htmlPane.setContentType("text/html");
        this.htmlPane.setEditorKit(new HTMLEditorKit());
        this.cardPanel.add((Component)new WHScrollPane(this.htmlPane), String.valueOf(2));
        this.imagePanel = new JPanel(new BorderLayout());
        this.imagePanel.setBackground(Color.white);
        this.imageLabel = new JLabel("", 0);
        this.imagePanel.add((Component)this.imageLabel, "Center");
        this.imageLabel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                ViewerFrame.this.zoom(e.getWheelRotation() > 0);
            }
        });
        this.cardPanel.add((Component)new WHScrollPane(this.imagePanel), String.valueOf(3));
        this.listTable = new JTable(new DefaultTableModel(0, 2){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }
        });
        this.listTable.setTableHeader(null);
        this.listTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.listTable.setColumnSelectionAllowed(true);
        this.listTable.setRowSelectionAllowed(true);
        this.listTable.getSelectionModel().setSelectionMode(2);
        WHScrollPane tableScrollPane = new WHScrollPane(this.listTable);
        tableScrollPane.getViewport().setBackground(Color.white);
        this.cardPanel.add((Component)tableScrollPane, String.valueOf(4));
        this.openView(viewIndex);
        contentPane.add((Component)this.cardPanel, "Center");
        this.pack();
    }

    private void findText(int type) {
        if (this.currentView == 0 || this.currentView == 1) {
            if (this.findDialog == null) {
                this.findDialog = new FindReplaceDialog(this);
            }
            JTextComponent textComponent = this.currentView == 0 ? this.textArea : this.xmlPane;
            if (type == 1) {
                this.findDialog.findNext(textComponent);
            } else if (type == 2) {
                this.findDialog.findPrev(textComponent);
            } else {
                this.findDialog.open(textComponent, false);
            }
        }
    }

    private void evaluateXPath(String text) {
        String htmlHeader = "<html><head></head><body style='font-family:Tahoma,Verdana;font-size:11pt;'>";
        String htmlFooter = "</body></html>";
        try {
            ListVariable result = XmlUtil.evaluateXPath(text, this.xmlPane.getText(), this.runtimeConfig);
            List resultList = result.toList();
            if (resultList.size() == 0) {
                this.xpathResultPane.setText("<html><head></head><body style='font-family:Tahoma,Verdana;font-size:11pt;'>No results</body></html>");
            } else {
                String tableHtml = "<table width='100%' cellspacing='0' cellpadding='2'>";
                Iterator iterator = resultList.iterator();
                int index = 0;
                while (iterator.hasNext()) {
                    Object curr = iterator.next();
                    tableHtml = tableHtml + "<tr style='background:" + (++index % 2 == 0 ? "#E1E1E1" : "#EEEEEE") + "'><td align='left' width='30'>" + index + ".&nbsp;</td><td align='left' nowrap>" + CommonUtil.escapeXml(curr.toString()) + "</td></tr>";
                }
                tableHtml = tableHtml + "</table>";
                this.xpathResultPane.setText("<html><head></head><body style='font-family:Tahoma,Verdana;font-size:11pt;'>" + tableHtml + "</body></html>");
                this.xpathResultPane.setCaretPosition(0);
            }
        }
        catch (XPathException e) {
            String html = "<html><head></head><body style='font-family:Tahoma,Verdana;font-size:11pt;'><div style='color:#800000'>" + e.getMessage() + "</div>" + "</body></html>";
            this.xpathResultPane.setText(html);
        }
    }

    private void prettyPrintXml() {
        boolean valid = this.validateXml(false);
        if (valid) {
            String xmlText = this.xmlPane.getText();
            try {
                String prettyXml = XmlUtil.prettyPrintXml(xmlText);
                this.xmlPane.setText(prettyXml);
                this.xmlPane.setCaretPosition(0);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "parsing error", 0);
            }
        }
    }

    private boolean validateXml(boolean showOkMessage) {
        XmlValidator validator = new XmlValidator();
        String s = this.value == null ? "" : this.value.toString();
        boolean valid = validator.parse(new InputSource(new StringReader(s)));
        if (valid) {
            if (showOkMessage) {
                GuiUtils.showInfoMessage("XML is well-formed.");
            }
        } else {
            String msg = "XML is not well-formed: " + validator.getException().getMessage() + " [line: " + validator.getLineNumber() + ", col: " + validator.getColumnNumber() + "].";
            GuiUtils.showErrorMessage(msg);
        }
        return valid;
    }

    private void refresh(int viewIndex) {
        switch (viewIndex) {
            case 0: {
                if (this.refreshed[0]) break;
                this.textArea.setText(this.value == null ? null : this.value.toString());
                this.textArea.setCaretPosition(0);
                break;
            }
            case 1: {
                if (!this.refreshed[1]) {
                    this.xmlPane.setText(this.value == null ? null : this.value.toString());
                }
                this.xmlPane.setCaretPosition(0);
                break;
            }
            case 2: {
                if (this.refreshed[2]) break;
                if (this.value != null) {
                    Pattern pattern = Pattern.compile("<head(.)*</head>", 96);
                    Matcher matcher = pattern.matcher(this.value.toString());
                    String htmlText = matcher.replaceFirst("");
                    this.htmlPane.setText(htmlText);
                } else {
                    this.htmlPane.setText(null);
                }
                this.htmlPane.setCaretPosition(0);
                break;
            }
            case 3: {
                if (this.refreshed[3]) break;
                if (this.value instanceof Variable) {
                    this.imageLabel.setIcon(this.createImgIcon());
                } else {
                    this.imageLabel.setIcon(null);
                }
                this.zoomFactorLabel.setText("  Size: " + this.zoomFactor + "%");
                this.imageLabel.repaint();
                this.imagePanel.getParent().validate();
                break;
            }
            case 4: {
                if (this.refreshed[4]) break;
                DefaultTableModel model = (DefaultTableModel)this.listTable.getModel();
                int rowCount = model.getRowCount();
                for (int i = rowCount - 1; i >= 0; --i) {
                    model.removeRow(i);
                }
                if (this.value instanceof Variable) {
                    Variable var = (Variable)this.value;
                    List list = var.toList();
                    for (int i = 0; i < list.size(); ++i) {
                        Object curr = list.get(i);
                        String stringValue = curr == null ? "" : curr.toString();
                        model.addRow(new String[]{String.valueOf(i + 1), stringValue});
                    }
                    break;
                }
                model.addRow(new String[]{"1", this.value == null ? "" : this.value.toString()});
            }
        }
        if (viewIndex >= 0 && viewIndex < this.refreshed.length) {
            this.refreshed[viewIndex] = true;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(640, 480);
    }

    private void updateControls() {
        this.findButton.setVisible(this.currentView == 0 || this.currentView == 1);
        this.xmlValidateButton.setVisible(this.currentView == 1);
        this.xmlPrettyPrintButton.setVisible(this.currentView == 1);
        this.zoomInButton.setVisible(this.currentView == 3);
        this.zoomOutButton.setVisible(this.currentView == 3);
        this.zoomFactorLabel.setVisible(this.currentView == 3);
        this.wrapTextCheckBox.setVisible(this.currentView == 0);
    }

    private void openView(int viewIndex) {
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        this.currentView = viewIndex;
        this.refresh(viewIndex);
        cardLayout.show(this.cardPanel, String.valueOf(viewIndex));
        this.updateControls();
    }

    @Override
    public void onChange(DropDownButton dropDownButton) {
        this.openView(dropDownButton.getSelectedItem());
    }

    public void setValue(Map properties) {
        if (properties != null && this.propertyName != null) {
            Object newValue = properties.get(this.propertyName);
            this.value = newValue;
            for (int i = 0; i < this.refreshed.length; ++i) {
                this.refreshed[i] = false;
            }
            this.refresh(this.currentView);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.keepSyncCheckBox) {
            boolean isSynchronized = this.keepSyncCheckBox.isSelected();
            if (isSynchronized) {
                this.nodeInfo.addSynchronizedView(this);
            } else {
                this.nodeInfo.removeSynchronizedView(this);
            }
        } else if (source == this.wrapTextCheckBox) {
            this.textArea.setLineWrap(this.wrapTextCheckBox.isSelected());
        }
    }

    private void zoom(boolean zoomIn) {
        if (zoomIn && this.zoomFactor < 500) {
            this.zoomFactor += 20;
        } else if (!zoomIn && this.zoomFactor > 20) {
            this.zoomFactor -= 20;
        }
        this.refreshed[this.currentView] = false;
        this.refresh(this.currentView);
    }

    private ImageIcon createImgIcon() {
        Variable var = (Variable)this.value;
        ImageIcon imageIcon = new ImageIcon(var.toBinary());
        Image img = imageIcon.getImage();
        int newWidth = (int)((double)(img.getWidth(this) * this.zoomFactor) / 100.0);
        int newHeight = (int)((double)(img.getHeight(this) * this.zoomFactor) / 100.0);
        if (newWidth > 0 && newHeight > 0) {
            Image resizedImg = this.zoomFactor != 100 ? img.getScaledInstance(newWidth, newHeight, 2) : img;
            imageIcon.setImage(resizedImg);
            return imageIcon;
        }
        return null;
    }

    @Override
    public void setVisible(boolean b) {
        Frame activeFrame;
        if (b && (activeFrame = GuiUtils.getActiveFrame()) != null) {
            GuiUtils.centerRelativeTo(this, activeFrame);
        }
        super.setVisible(b);
    }

    private abstract class MyAction
    extends AbstractAction {
        public MyAction(String text, Icon icon, String desc, KeyStroke keyStroke) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("AcceleratorKey", keyStroke);
        }
    }
}

