/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.util.HashMap;
import java.util.List;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexConfig {
    public static final Logger log = LoggerFactory.getLogger(SolrIndexConfig.class);
    public static final String defaultsName = "indexDefaults";
    public static final String DEFAULT_MERGE_POLICY_CLASSNAME = LogByteSizeMergePolicy.class.getName();
    public static final String DEFAULT_MERGE_SCHEDULER_CLASSNAME = ConcurrentMergeScheduler.class.getName();
    static final SolrIndexConfig defaultDefaults = new SolrIndexConfig();
    public final boolean useCompoundFile;
    public final int maxBufferedDocs;
    public final int maxMergeDocs;
    public final int mergeFactor;
    public final double ramBufferSizeMB;
    public final int maxFieldLength;
    public final int writeLockTimeout;
    public final int commitLockTimeout;
    public final String lockType;
    public final PluginInfo mergePolicyInfo;
    public final PluginInfo mergeSchedulerInfo;
    public final boolean luceneAutoCommit;
    public final int termIndexInterval;
    public String infoStreamFile = null;

    private SolrIndexConfig() {
        this.useCompoundFile = true;
        this.maxBufferedDocs = -1;
        this.maxMergeDocs = -1;
        this.mergeFactor = -1;
        this.ramBufferSizeMB = 16.0;
        this.maxFieldLength = -1;
        this.writeLockTimeout = -1;
        this.commitLockTimeout = -1;
        this.lockType = null;
        this.luceneAutoCommit = false;
        this.termIndexInterval = 128;
        this.mergePolicyInfo = null;
        this.mergeSchedulerInfo = null;
    }

    public SolrIndexConfig(SolrConfig solrConfig, String prefix, SolrIndexConfig def) {
        HashMap<String, String> atrs;
        if (prefix == null) {
            prefix = defaultsName;
        }
        if (def == null) {
            def = defaultDefaults;
        }
        this.useCompoundFile = solrConfig.getBool(prefix + "/useCompoundFile", def.useCompoundFile);
        this.maxBufferedDocs = solrConfig.getInt(prefix + "/maxBufferedDocs", def.maxBufferedDocs);
        this.maxMergeDocs = solrConfig.getInt(prefix + "/maxMergeDocs", def.maxMergeDocs);
        this.mergeFactor = solrConfig.getInt(prefix + "/mergeFactor", def.mergeFactor);
        this.ramBufferSizeMB = solrConfig.getDouble(prefix + "/ramBufferSizeMB", def.ramBufferSizeMB);
        this.maxFieldLength = solrConfig.getInt(prefix + "/maxFieldLength", def.maxFieldLength);
        this.writeLockTimeout = solrConfig.getInt(prefix + "/writeLockTimeout", def.writeLockTimeout);
        this.commitLockTimeout = solrConfig.getInt(prefix + "/commitLockTimeout", def.commitLockTimeout);
        this.lockType = solrConfig.get(prefix + "/lockType", def.lockType);
        String str = solrConfig.get(prefix + "/mergeScheduler/text()", null);
        if (str != null && str.trim().length() > 0) {
            log.warn("deprecated syntax : <mergeScheduler>[classname]</mergeScheduler>");
            atrs = new HashMap<String, String>();
            atrs.put("class", str.trim());
            this.mergeSchedulerInfo = new PluginInfo("mergeScheduler", atrs, null, null);
        } else {
            this.mergeSchedulerInfo = this.getPluginInfo(prefix + "/mergeScheduler", solrConfig, def.mergeSchedulerInfo);
        }
        str = solrConfig.get(prefix + "/mergePolicy/text()", null);
        if (str != null && str.trim().length() > 0) {
            log.warn("deprecated syntax : <mergePolicy>[classname]</mergePolicy>");
            atrs = new HashMap();
            atrs.put("class", str.trim());
            this.mergePolicyInfo = new PluginInfo("mergePolicy", atrs, null, null);
        } else {
            this.mergePolicyInfo = this.getPluginInfo(prefix + "/mergePolicy", solrConfig, def.mergePolicyInfo);
        }
        this.luceneAutoCommit = solrConfig.getBool(prefix + "/luceneAutoCommit", def.luceneAutoCommit);
        this.termIndexInterval = solrConfig.getInt(prefix + "/termIndexInterval", def.termIndexInterval);
        boolean infoStreamEnabled = solrConfig.getBool(prefix + "/infoStream", false);
        if (infoStreamEnabled) {
            this.infoStreamFile = solrConfig.get(prefix + "/infoStream/@file", null);
            log.info("IndexWriter infoStream debug log is enabled: " + this.infoStreamFile);
        }
    }

    private PluginInfo getPluginInfo(String path, SolrConfig solrConfig, PluginInfo def) {
        List<PluginInfo> l = solrConfig.readPluginInfos(path, false, true);
        return l.isEmpty() ? def : l.get(0);
    }
}

