/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public interface Thesaurus extends BusinessEntity, WikittyTreeNode {     String EXT_THESAURUS = "Thesaurus";
     String FIELD_THESAURUS_TAGS = "tags";
     String FQ_FIELD_THESAURUS_TAGS = EXT_THESAURUS + ".tags";
     String FIELD_THESAURUS_ORDER = "order";
     String FQ_FIELD_THESAURUS_ORDER = EXT_THESAURUS + ".order";
     String FIELD_THESAURUS_COMMENT = "comment";
     String FQ_FIELD_THESAURUS_COMMENT = EXT_THESAURUS + ".comment";
     String FIELD_THESAURUS_ROOTTHESAURUS = "rootThesaurus";
     String FQ_FIELD_THESAURUS_ROOTTHESAURUS = EXT_THESAURUS + ".rootThesaurus";
    /**
     * getTags :
     * Thesaurus extension for {@link WikittyTreeNode}.   Changes in this extension : <ul>  <li>4.0 : ajout des contraintes notNull/unique  <li>3.0 : add rootThesaurus : rootThesaurus reference  <li>2.0 : add order field (numeric)  <li>1.0 : intial version </ul>
     * @return Set<String> 
     */

     Set<String> getTags();

    /**
     * setTags :
     * @param tags 
     */

     void setTags(Set<String> tags);

    /**
     * addAllTags :
     * @param tags 
     */

     void addAllTags(Set<String> tags);

    /**
     * addTags :
     * @param element 
     */

     void addTags(String element);

    /**
     * removeTags :
     * @param element 
     */

     void removeTags(String element);

    /**
     * clearTags :
     */

     void clearTags();

    /**
     * getOrder :
     * Thesaurus extension for {@link WikittyTreeNode}.   Changes in this extension : <ul>  <li>4.0 : ajout des contraintes notNull/unique  <li>3.0 : add rootThesaurus : rootThesaurus reference  <li>2.0 : add order field (numeric)  <li>1.0 : intial version </ul>
     * @return int 
     */

     int getOrder();

    /**
     * setOrder :
     * @param order 
     */

     void setOrder(int order);

    /**
     * getComment :
     * Thesaurus extension for {@link WikittyTreeNode}.   Changes in this extension : <ul>  <li>4.0 : ajout des contraintes notNull/unique  <li>3.0 : add rootThesaurus : rootThesaurus reference  <li>2.0 : add order field (numeric)  <li>1.0 : intial version </ul>
     * @return String 
     */

     String getComment();

    /**
     * setComment :
     * @param comment 
     */

     void setComment(String comment);

    /**
     * getRootThesaurus :
     * Root thesaurus wikitty id.
     * @return String 
     */

     String getRootThesaurus();

    /**
     * setRootThesaurus :
     * @param rootThesaurus 
     */

     void setRootThesaurus(String rootThesaurus);

    /**
     * getName :
     * @return String 
     */

     String getName();

    /**
     * setName :
     * @param name 
     */

     void setName(String name);

    /**
     * getAttachment :
     * @return Set<String> 
     */

     Set<String> getAttachment();

    /**
     * setAttachment :
     * @param attachment 
     */

     void setAttachment(Set<String> attachment);

    /**
     * addAllAttachment :
     * @param attachment 
     */

     void addAllAttachment(Set<String> attachment);

    /**
     * addAttachment :
     * @param element 
     */

     void addAttachment(String element);

    /**
     * removeAttachment :
     * @param element 
     */

     void removeAttachment(String element);

    /**
     * clearAttachment :
     */

     void clearAttachment();

    /**
     * getParent :
     * @return String 
     */

     String getParent();

    /**
     * setParent :
     * @param parent 
     */

     void setParent(String parent);


} //Thesaurus
