/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class StatusAbstract extends BusinessEntityImpl implements Status {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionStatus;
    /**
     * getName :
     * @return String 
     */

    @Override
    public String getName() {
        String value = StatusHelper.getName(getWikitty());
        return value;
}

    /**
     * setName :
     * @param name 
     */

    @Override
    public void setName(String name) {
        String oldValue = getName();
        StatusHelper.setName(getWikitty(), name);
        getPropertyChangeSupport().firePropertyChange(Status.FIELD_STATUS_NAME, oldValue, getName());
}

    /**
     * getValue :
     * @return int 
     */

    @Override
    public int getValue() {
        int value = StatusHelper.getValue(getWikitty());
        return value;
}

    /**
     * setValue :
     * @param value 
     */

    @Override
    public void setValue(int value) {
        int oldValue = getValue();
        StatusHelper.setValue(getWikitty(), value);
        getPropertyChangeSupport().firePropertyChange(Status.FIELD_STATUS_VALUE, oldValue, getValue());
}

    /**
     * getDescription :
     * @return String 
     */

    @Override
    public String getDescription() {
        String value = StatusHelper.getDescription(getWikitty());
        return value;
}

    /**
     * setDescription :
     * @param description 
     */

    @Override
    public void setDescription(String description) {
        String oldValue = getDescription();
        StatusHelper.setDescription(getWikitty(), description);
        getPropertyChangeSupport().firePropertyChange(Status.FIELD_STATUS_DESCRIPTION, oldValue, getDescription());
}

    /**
     * getModifiable :
     * @return boolean 
     */

    @Override
    public boolean getModifiable() {
        boolean value = StatusHelper.getModifiable(getWikitty());
        return value;
}

    /**
     * setModifiable :
     * @param modifiable 
     */

    @Override
    public void setModifiable(boolean modifiable) {
        boolean oldValue = getModifiable();
        StatusHelper.setModifiable(getWikitty(), modifiable);
        getPropertyChangeSupport().firePropertyChange(Status.FIELD_STATUS_MODIFIABLE, oldValue, getModifiable());
}

    /**
     * StatusAbstract :
     */

    public StatusAbstract() {
        super();
}

    /**
     * StatusAbstract :
     * @param wikitty 
     */

    public StatusAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * StatusAbstract :
     * @param businessEntityImpl 
     */

    public StatusAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionStatus =
                new WikittyExtension(EXT_STATUS,
                                     "1.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String name unique=\"true\"", 
                                             "Numeric value unique=\"true\"", 
                                             "String description unique=\"true\"", 
                                             "boolean modifiable unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionStatus);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //StatusAbstract
