/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeHelper;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class RootThesaurusAbstract extends BusinessEntityImpl implements RootThesaurus {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionRootThesaurus;
    /**
     * getName :
     * @return String 
     */

    public String getName() {
        String value = WikittyTreeNodeHelper.getName(getWikitty());
        return value;
}

    /**
     * setName :
     * @param name 
     */

    public void setName(String name) {
        String oldValue = getName();
        WikittyTreeNodeHelper.setName(getWikitty(), name);
        getPropertyChangeSupport().firePropertyChange(WikittyTreeNode.FIELD_WIKITTYTREENODE_NAME, oldValue, getName());
}

    /**
     * getAttachment :
     * @return Set<String> 
     */

    public Set<String> getAttachment() {
        Set<String> result = WikittyTreeNodeHelper.getAttachment(getWikitty());
        return result;
}

    /**
     * setAttachment :
     * @param attachment 
     */

    public void setAttachment(Set<String> attachment) {
        Set<String> oldValue = getAttachment();
        WikittyTreeNodeHelper.setAttachment(getWikitty(), attachment);
        getPropertyChangeSupport().firePropertyChange(WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, oldValue, getAttachment());
}

    /**
     * addAllAttachment :
     * @param attachment 
     */

    public void addAllAttachment(Set<String> attachment) {
        Set<String> oldValue = getAttachment();
        WikittyTreeNodeHelper.addAllAttachment(getWikitty(), attachment);
        getPropertyChangeSupport().firePropertyChange(WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, oldValue, getAttachment());
}

    /**
     * addAttachment :
     * @param element 
     */

    public void addAttachment(String element) {
        WikittyTreeNodeHelper.addAttachment(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, null, getAttachment());
}

    /**
     * removeAttachment :
     * @param element 
     */

    public void removeAttachment(String element) {
        WikittyTreeNodeHelper.removeAttachment(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, null, getAttachment());
}

    /**
     * clearAttachment :
     */

    public void clearAttachment() {
        WikittyTreeNodeHelper.clearAttachment(getWikitty());
        getPropertyChangeSupport().firePropertyChange(WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, null, getAttachment());
}

    /**
     * getParent :
     * @return String 
     */

    public String getParent() {
        String value = WikittyTreeNodeHelper.getParent(getWikitty());
        return value;
}

    /**
     * setParent :
     * @param parent 
     */

    public void setParent(String parent) {
        String oldValue = getParent();
        WikittyTreeNodeHelper.setParent(getWikitty(), parent);
        getPropertyChangeSupport().firePropertyChange(WikittyTreeNode.FIELD_WIKITTYTREENODE_PARENT, oldValue, getParent());
}

    /**
     * RootThesaurusAbstract :
     */

    public RootThesaurusAbstract() {
        super();
}

    /**
     * RootThesaurusAbstract :
     * @param wikitty 
     */

    public RootThesaurusAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * RootThesaurusAbstract :
     * @param businessEntityImpl 
     */

    public RootThesaurusAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionRootThesaurus =
                new WikittyExtension(EXT_ROOTTHESAURUS,
                                     "2.0", // version
                                     WikittyTreeNode.EXT_WIKITTYTREENODE,
                                     WikittyUtil.buildFieldMapExtension( // building field map
));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(WikittyTreeNodeAbstract.extensions); 
        // current after requires ones

        exts.add(extensionRootThesaurus);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //RootThesaurusAbstract
