/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyTreeNode;
import org.nuiton.wikitty.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.WikittyTreeNodeImpl;
import org.nuiton.wikitty.WikittyUser;
import org.nuiton.wikitty.WikittyUserAbstract;
import org.nuiton.wikitty.WikittyUserImpl;
import org.nuiton.wikitty.WikittyUtil;


public  abstract class QueryMakerAbstract extends BusinessEntityWikitty implements QueryMaker {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionQueryMaker;
    /**
     * getQueries :
     * @return Set<String> 
     */

    @Override
    public Set<String> getQueries() {
        Set<String> result = QueryMakerHelper.getQueries(getWikitty());
        return result;
}

    /**
     * addQueries :
     * @param element 
     */

    @Override
    public void addQueries(String element) {
        QueryMakerHelper.addQueries(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(QueryMaker.FIELD_QUERYMAKER_QUERIES, null, getQueries());
}

    /**
     * removeQueries :
     * @param element 
     */

    @Override
    public void removeQueries(String element) {
        QueryMakerHelper.removeQueries(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(QueryMaker.FIELD_QUERYMAKER_QUERIES, null, getQueries());
}

    /**
     * clearQueries :
     */

    @Override
    public void clearQueries() {
        QueryMakerHelper.clearQueries(getWikitty());
        getPropertyChangeSupport().firePropertyChange(QueryMaker.FIELD_QUERYMAKER_QUERIES, null, getQueries());
}

    /**
     * QueryMakerAbstract :
     */

    public QueryMakerAbstract() {
        super();
}

    /**
     * QueryMakerAbstract :
     * @param wikitty 
     */

    public QueryMakerAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * QueryMakerAbstract :
     * @param businessEntityWikitty 
     */

    public QueryMakerAbstract(BusinessEntityWikitty businessEntityWikitty) {
        super(businessEntityWikitty.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionQueryMaker =
                new WikittyExtension(EXT_QUERYMAKER,
                                     "1.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String queries[0-*] unique=true"));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionQueryMaker);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //QueryMakerAbstract
