/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter.time;

import java.sql.Date;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.ObjectConverterManager;
import jidefx.utils.converter.time.TemporalAccessConverter;

public class LocalTimeConverter
extends TemporalAccessConverter<LocalTime> {
    private static final DateTimeFormatter _defaultFormat = DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM);
    private static final DateTimeFormatter _shortFormat = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT);
    private static final DateTimeFormatter _mediumFormat = DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM);
    private static final DateTimeFormatter _longFormat = DateTimeFormatter.ofLocalizedTime(FormatStyle.LONG);
    private static final DateTimeFormatter _fullFormat = DateTimeFormatter.ofLocalizedTime(FormatStyle.FULL);

    public LocalTimeConverter() {
        this.setDefaultDateTimeFormatter(_defaultFormat);
    }

    @Override
    public synchronized LocalTime fromString(String string, ConverterContext context) {
        TemporalAccessor temporalAccessor = this.temporalFromString(string, context);
        if (temporalAccessor != null) {
            return LocalTime.from(temporalAccessor);
        }
        return null;
    }

    @Override
    protected DateTimeFormatter getFullDateTimeFormatter() {
        return _fullFormat;
    }

    @Override
    protected DateTimeFormatter getLongDateTimeFormatter() {
        return _longFormat;
    }

    @Override
    protected DateTimeFormatter getMediumDateTimeFormatter() {
        return _mediumFormat;
    }

    @Override
    protected DateTimeFormatter getShortDateTimeFormatter() {
        return _shortFormat;
    }

    public static void main(String[] args) {
        ObjectConverterManager.getInstance().getConverter(Date.class);
    }
}

