/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter.time;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.time.TemporalAccessConverter;

public class LocalDateConverter
extends TemporalAccessConverter<LocalDate> {
    private static final DateTimeFormatter _defaultFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);
    private static final DateTimeFormatter _shortFormat = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT);
    private static final DateTimeFormatter _mediumFormat = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);
    private static final DateTimeFormatter _longFormat = DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG);
    private static final DateTimeFormatter _fullFormat = DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL);

    public LocalDateConverter() {
        this.setDefaultDateTimeFormatter(_defaultFormatter);
    }

    public synchronized LocalDate fromString(String string, String pattern) {
        return LocalDate.from(DateTimeFormatter.ofPattern(pattern).parse(string));
    }

    @Override
    public synchronized LocalDate fromString(String string, ConverterContext context) {
        String[] formatStrings;
        TemporalAccessor temporalAccessor = this.temporalFromString(string, context);
        if (temporalAccessor != null) {
            return LocalDate.from(temporalAccessor);
        }
        for (String formatString : formatStrings = new String[]{"M/d/yyyy", "MM/dd/yyyy", "MMM d, yy", "MMM d, yyyy", "MMMMM d, yyyy", "yyyy-MM-dd", "yy-MM-dd", "yyyyMMdd", "yyMMdd", "dd-MMM-yy", "d-MMM-yy", "dd-MMM-yyyy", "d-MMM-yyyy"}) {
            try {
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern(formatString);
                return LocalDate.from(dtf.withLocale(Locale.getDefault()).parse(string));
            }
            catch (Exception ignored) {
            }
        }
        return null;
    }

    @Override
    protected DateTimeFormatter getFullDateTimeFormatter() {
        return _fullFormat;
    }

    @Override
    protected DateTimeFormatter getLongDateTimeFormatter() {
        return _longFormat;
    }

    @Override
    protected DateTimeFormatter getMediumDateTimeFormatter() {
        return _mediumFormat;
    }

    @Override
    protected DateTimeFormatter getShortDateTimeFormatter() {
        return _shortFormat;
    }
}

