/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter.javafx;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Insets;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.ValuesConverter;

public class InsetsConverter
extends ValuesConverter<Insets, Double> {
    public InsetsConverter() {
        super("; ", Double.class);
    }

    public InsetsConverter(String separator) {
        super(separator, Double.class);
    }

    @Override
    public String toString(Insets insets, ConverterContext context) {
        if (insets == null) {
            return null;
        }
        ArrayList<Double> list = new ArrayList<Double>(4);
        list.add(insets.getTop());
        list.add(insets.getRight());
        list.add(insets.getBottom());
        list.add(insets.getLeft());
        return this.valuesToString(list, context);
    }

    @Override
    public Insets fromString(String string, ConverterContext context) {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        List objects = this.valuesFromString(string, context);
        double top = 0.0;
        if (objects.size() >= 1) {
            top = (Double)objects.get(0);
        }
        double right = 0.0;
        if (objects.size() >= 2) {
            right = (Double)objects.get(1);
        }
        double bottom = 0.0;
        if (objects.size() >= 3) {
            bottom = (Double)objects.get(2);
        }
        double left = 0.0;
        if (objects.size() >= 4) {
            left = (Double)objects.get(3);
        }
        return new Insets(top, right, bottom, left);
    }
}

