/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.DefaultObjectConverter;

public class MonthNameConverter
extends DefaultObjectConverter<Integer> {
    public static final ConverterContext CONTEXT = new ConverterContext("MonthName");
    public static final DateFormat CONCISE_FORMAT = new SimpleDateFormat("M");
    public static final DateFormat SHORT_FORMAT = new SimpleDateFormat("MM");
    public static final DateFormat MEDIUM_FORMAT = new SimpleDateFormat("MMM");
    public static final DateFormat LONG_FORMAT = new SimpleDateFormat("MMMMM");
    private DateFormat _defaultDateFormat = MEDIUM_FORMAT;
    static final Calendar CAL = Calendar.getInstance();

    @Override
    public String toString(Integer value, ConverterContext context) {
        if (value == null) {
            return "";
        }
        return this.getDefaultDateFormat().format(MonthNameConverter.getCalendarByMonth(value).getTime());
    }

    private static Calendar getCalendarByMonth(int month) {
        CAL.set(2, month);
        return CAL;
    }

    @Override
    public Integer fromString(String string, ConverterContext context) {
        Calendar calendar = Calendar.getInstance();
        try {
            Date time = this.getDefaultDateFormat().parse(string);
            calendar.setTime(time);
        }
        catch (ParseException e1) {
            try {
                Date time = MEDIUM_FORMAT.parse(string);
                calendar.setTime(time);
            }
            catch (ParseException e2) {
                try {
                    Date time = SHORT_FORMAT.parse(string);
                    calendar.setTime(time);
                }
                catch (ParseException e3) {
                    try {
                        Date time = LONG_FORMAT.parse(string);
                        calendar.setTime(time);
                    }
                    catch (ParseException e4) {
                        try {
                            Date time = CONCISE_FORMAT.parse(string);
                            calendar.setTime(time);
                        }
                        catch (ParseException e5) {
                            return null;
                        }
                    }
                }
            }
        }
        return calendar.get(2);
    }

    public DateFormat getDefaultDateFormat() {
        return this._defaultDateFormat;
    }

    public void setDefaultDateFormat(DateFormat defaultDateFormat) {
        this._defaultDateFormat = defaultDateFormat;
    }

    static {
        CAL.set(5, 1);
    }
}

