/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import jidefx.utils.converter.AbstractNumberConverter;
import jidefx.utils.converter.ConverterContext;

public class BigDecimalConverter
extends AbstractNumberConverter<BigDecimal> {
    public BigDecimalConverter() {
        super(new DecimalFormat("#,##0.00"));
    }

    public BigDecimalConverter(NumberFormat format) {
        super(format);
    }

    @Override
    public BigDecimal fromString(String string, ConverterContext context) {
        Number value = this.numberFromString(string, context);
        if (value instanceof Double) {
            return new BigDecimal(string);
        }
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        return null;
    }

    @Override
    public String toString(BigDecimal decimal, ConverterContext convertercontext) {
        if (Double.isNaN(decimal.doubleValue())) {
            return "";
        }
        return super.toString(decimal, convertercontext);
    }
}

