/*
 * Decompiled with CFR 0.152.
 */
package com.jgeppert.struts2.jquery.components;

import com.jgeppert.struts2.jquery.components.AbstractRemoteBean;
import com.jgeppert.struts2.jquery.components.ButtonBean;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.Writer;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.components.Form;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.annotations.StrutsTagSkipInheritance;

@StrutsTag(name="submit", tldTagClass="com.jgeppert.struts2.jquery.views.jsp.ui.SubmitTag", description="Render a submit button", allowDynamicAttributes=true)
public class Submit
extends AbstractRemoteBean
implements ButtonBean {
    private static final Logger LOG = LoggerFactory.getLogger(Submit.class);
    private static final transient Random RANDOM = new Random();
    public static final String TEMPLATE = "submit";
    public static final String TEMPLATE_CLOSE = "submit-close";
    public static final String JQUERYACTION = "button";
    public static final String COMPONENT_NAME = Submit.class.getName();
    protected String src;
    protected String type;
    protected String clearForm;
    protected String resetForm;
    protected String iframe;
    protected String onClickTopics;
    protected String openDialog;
    protected String parentTheme;
    protected String button;
    protected String buttonIcon;
    protected String buttonIconSecondary;
    protected String buttonText;
    protected String validate;
    protected String validateFunction;
    protected String formFilter;
    protected String replaceTarget;

    public Submit(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public String getDefaultOpenTemplate() {
        return TEMPLATE;
    }

    protected String getDefaultTemplate() {
        return TEMPLATE_CLOSE;
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public void evaluateParams() {
        super.evaluateExtraParams();
        this.addParameter("jqueryaction", JQUERYACTION);
        if (this.key == null && this.value == null) {
            this.value = "Submit";
        }
        if (this.key != null && this.value == null) {
            this.value = "%{getText('" + this.key + "')}";
        }
        super.evaluateParams();
    }

    public void evaluateExtraParams() {
        super.evaluateExtraParams();
        if (this.type != null) {
            this.addParameter("type", this.findString(this.type));
        }
        if (this.src != null) {
            this.addParameter("src", this.findString(this.src));
        }
        if (this.clearForm != null) {
            this.addParameter("clearForm", this.findValue(this.clearForm, Boolean.class));
        }
        if (this.resetForm != null) {
            this.addParameter("resetForm", this.findValue(this.resetForm, Boolean.class));
        }
        if (this.iframe != null) {
            this.addParameter("iframe", this.findValue(this.iframe, Boolean.class));
        }
        if (this.onClickTopics != null) {
            this.addParameter("onClickTopics", this.findString(this.onClickTopics));
        }
        if (this.openDialog != null) {
            this.addParameter("openDialog", this.findString(this.openDialog));
        }
        if (this.button != null) {
            this.addParameter(JQUERYACTION, this.findValue(this.button, Boolean.class));
        }
        if (this.buttonIcon != null) {
            this.addParameter("buttonIcon", this.findString(this.buttonIcon));
        }
        if (this.buttonIconSecondary != null) {
            this.addParameter("buttonIconSecondary", this.findString(this.buttonIconSecondary));
        }
        if (this.buttonText != null) {
            this.addParameter("buttonText", this.findValue(this.buttonText, Boolean.class));
        }
        if (this.validate != null) {
            this.addParameter("validate", this.findValue(this.validate, Boolean.class));
        }
        if (this.validateFunction != null) {
            this.addParameter("validateFunction", this.findString(this.validateFunction));
        }
        if (this.formFilter != null) {
            this.addParameter("formFilter", this.findString(this.formFilter));
        }
        if (this.replaceTarget != null) {
            this.addParameter("replaceTarget", this.findValue(this.replaceTarget, Boolean.class));
        }
        if (this.id == null || this.id.length() == 0) {
            int nextInt = RANDOM.nextInt();
            nextInt = nextInt == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(nextInt);
            this.id = "submit_" + String.valueOf(nextInt);
            this.addParameter("id", this.id);
        }
        Form form = (Form)this.findAncestor(Form.class);
        if (this.parentTheme != null) {
            this.addParameter("parentTheme", this.findString(this.parentTheme));
        } else if (form != null) {
            if (form != null) {
                this.addParameter("parentTheme", form.getTheme());
            }
        } else {
            this.addParameter("parentTheme", "simple");
        }
        if (form != null && (this.formIds == null || this.formIds.length() <= 0)) {
            this.addParameter("formIds", form.getId());
        }
    }

    @StrutsTagSkipInheritance
    public void setTheme(String theme) {
        super.setTheme(theme);
    }

    public String getTheme() {
        return "jquery";
    }

    protected boolean supportsImageType() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean end(Writer writer, String body) {
        this.evaluateParams();
        try {
            this.addParameter("body", body);
            this.mergeTemplate(writer, this.buildTemplateName(this.template, this.getDefaultTemplate()));
        }
        catch (Exception e) {
            LOG.error("error when rendering", (Throwable)e, new String[0]);
        }
        finally {
            this.popComponentStack();
        }
        return false;
    }

    @StrutsTagAttribute(description="The type of submit to use. Valid values are <i>input</i>, <i>button</i> and <i>image</i>.", defaultValue="input")
    public void setType(String type) {
        this.type = type;
    }

    @StrutsTagAttribute(description="Supply an image src for <i>image</i> type submit button. Will have no effect for types <i>input</i> and <i>button</i>.")
    public void setSrc(String src) {
        this.src = src;
    }

    @StrutsTagAttribute(description="Clear all form fields after successful submit. Default: false", type="Boolean")
    public void setClearForm(String clearForm) {
        this.clearForm = clearForm;
    }

    @StrutsTagAttribute(description="Reset the form after successful submit. Default: false", type="Boolean")
    public void setResetForm(String resetForm) {
        this.resetForm = resetForm;
    }

    @StrutsTagAttribute(description="Boolean flag indicating whether the form should always target the server response to an iframe. This is useful in conjuction with file uploads. Default: false", type="Boolean")
    public void setIframe(String iframe) {
        this.iframe = iframe;
    }

    @StrutsTagAttribute(name="onClickTopics", description="A comma delimited list of topics that published when the element is clicked", type="String", defaultValue="")
    public void setOnClickTopics(String onClickTopics) {
        this.onClickTopics = onClickTopics;
    }

    @StrutsTagAttribute(description="id of dialog that will be opened when clicked.")
    public void setOpenDialog(String openDialog) {
        this.openDialog = openDialog;
    }

    @StrutsTagAttribute(description="The parent theme. Default: value of parent form tag or simple if no parent form tag is available")
    public void setParentTheme(String parentTheme) {
        this.parentTheme = parentTheme;
    }

    @StrutsTagAttribute(description="jQuery UI Button", defaultValue="false", type="Boolean")
    public void setButton(String button) {
        this.button = button;
    }

    @StrutsTagAttribute(description="Icons to display. The primary icon is displayed on the left of the label text. Value must be a classname (String), eg. ui-icon-gear.")
    public void setButtonIcon(String buttonIcon) {
        this.buttonIcon = buttonIcon;
    }

    @StrutsTagAttribute(description="Icons to display. The secondary icon is displayed on the right of the label text. Value must be a classname (String), eg. ui-icon-gear.")
    public void setButtonIconSecondary(String buttonIconSecondary) {
        this.buttonIconSecondary = buttonIconSecondary;
    }

    @StrutsTagAttribute(description="Whether to show any text - when set to false (display no text), icons (see icons option) must be enabled, otherwise it'll be ignored.", defaultValue="true", type="Boolean")
    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    @StrutsTagAttribute(description="A function that handle the client validation result. eg.: myValidation(form, errors)")
    public void setValidateFunction(String validateFunction) {
        this.validateFunction = validateFunction;
    }

    @StrutsTagAttribute(description="Enable client AJAX validation", defaultValue="false", type="Boolean")
    public void setValidate(String validate) {
        this.validate = validate;
    }

    @StrutsTagAttribute(description="Function name used to filter the fields of the form.")
    public void setFormFilter(String formFilter) {
        this.formFilter = formFilter;
    }

    @StrutsTagAttribute(description="Set to true if the target should be replaced or false if only the target contents should be replaced.", defaultValue="false", type="Boolean")
    public void setReplaceTarget(String replaceTarget) {
        this.replaceTarget = replaceTarget;
    }
}

