/*
 * jquery.subscribe.1.1
 * 
 * Implementation of publish/subcription framework for jQuery
 * Requires use of jQuery. Tested with jQuery 1.3 and above
 *
 *
 * Copyright (c) 2008 Eric Chijioke (obinna a-t g mail dot c o m)
 *
 * 
 * Dual licensed under the MIT and GPL licenses:
 *   http://www.opensource.org/licenses/mit-license.php
 *   http://www.gnu.org/licenses/gpl.html
 *
 *  Release Notes:
 *  
 *  version 1.1:
 *  
 *  Fixed unexpected behavior which can occur when a script in a embedded page (page loaded in div,tab etc.) subscribes a handler for a topic using
 *  the jQuery subscribe ($.subscribe) or a no-id element but this subscribe plugin is not reloaded within that embedded page (for example, when
 *  script is included in containing page) . In this case, if the embedded page is reloaded without reloading the entire page (and plugin), the
 *  subscription could be made multiple times for the topic, which will call the handler multiple times each time the topic is published. 
 *  Code has been added to prevent this when the subscription is made using the non-element subscribe ($.subscribe()), which assures that only one
 *  subscription is made for a topic for a given window/frame. To prevent this from happening for an element subscription ($elem.subscribe()), make
 *  sure that the element has an id attribute.
 */

(function(a){_subscribe_topics={};_subscribe_handlers={};_subscribe_getDocumentWindow=function(b){return b.parentWindow||b.defaultView};a.fn.extend({createTopic:function(b){if(b&&!_subscribe_topics[b]){_subscribe_topics[b]={};_subscribe_topics[b].objects={};_subscribe_topics[b].objects.__noId__=[]}return this},destroyTopic:function(c){if(c&&_subscribe_topics[c]){for(i in _subscribe_topics[c].objects){var b=_subscribe_topics[c].objects[i];if(a.isArray(b)){if(b.length>0){for(j in b){b[j].unbind(c)}}}else{b.unbind(c,data)}}}delete _subscribe_topics[c];return this},subscribe:function(c,e,h){if(this[0]&&c&&e){this.createTopic(c);if(this.attr("id")){_subscribe_topics[c].objects[this.attr("id")]=this}else{var k=_subscribe_topics[c].objects.__noId__;if(this[0].nodeType==9){for(var b in k){var g=k[b];if(g[0].nodeType==9&&_subscribe_getDocumentWindow(this[0]).frameElement==_subscribe_getDocumentWindow(g[0]).frameElement){return this}}}var f=false;for(var d=0;d<k.length;d++){if(k[d]==this){f=true;break}}if(!f){_subscribe_topics[c].objects.__noId__.push(this)}}if(typeof(e)=="function"){this.bind(c,h,e)}else{if(typeof(e)=="string"&&typeof(_subscribe_handlers[e])=="function"){this.bind(c,h,_subscribe_handlers[e])}}}return this},unsubscribe:function(c){if(c){if(_subscribe_topics[c]){if(this.attr("id")){var b=_subscribe_topics[c].objects[this.attr("id")];if(b){delete _subscribe_topics[c].objects[this.attr("id")]}}else{var e=_subscribe_topics[c].objects.__noId__;for(var d=0;d<e.length;d++){if(e[d]==this){subscribe_topics[c].objects.__noId__.splice(index,1);break}}}}this.unbind(c)}return this},publish:function(d,g,b){if(d){this.createTopic(d);var e=function(){this.isImmediatePropagationStopped=function(){return true};(new a.Event).stopPropagation();if(this.originalEvent){this.originalEvent.isImmediatePropagationStopped=function(){return true};this.originalEvent.stopPropagation=e}};var f=jQuery.Event(d);a.extend(f,{originalEvent:b,stopPropagation:e});for(i in _subscribe_topics[d].objects){var c=_subscribe_topics[d].objects[i];if(a.isArray(c)){if(c.length>0){for(j in c){c[j].trigger(f,g)}}}else{c.trigger(f,g)}}}return this},publishOnEvent:function(c,b,d){if(c&&b){this.createTopic(b);this.bind(c,d,function(f){a(this).publish(b,f.data,f)})}return this}});a.extend({subscribe:function(b,c,d){return a().subscribe(b,c,d)},unsubscribe:function(b,c,d){return a().unsubscribe(b,c,d)},subscribeHandler:function(b,c){if(b&&c&&typeof(c)=="function"){_subscribe_handlers[b]=c}return a()},publish:function(b,c){return a().publish(b,c)},createTopic:function(b){return a().createTopic(b)},destroyTopic:function(b){return a().destroyTopic(b)}})})(jQuery);