/*
 * Decompiled with CFR 0.152.
 */
package com.jgeppert.struts2.jquery.components;

import com.jgeppert.struts2.jquery.components.AbstractFormElement;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.annotations.StrutsTagSkipInheritance;

@StrutsTag(name="textfield", tldTagClass="com.jgeppert.struts2.jquery.views.jsp.ui.TextfieldTag", description="Render HTML textfield providing content from remote call via AJAX")
public class Textfield
extends AbstractFormElement {
    public static final String TEMPLATE = "textfield";
    public static final String TEMPLATE_CLOSE = "textfield-close";
    public static final String COMPONENT_NAME = Textfield.class.getName();
    private static final transient Random RANDOM = new Random();
    public static final String JQUERYACTION = "container";
    protected String maxlength;
    protected String readonly;
    protected String size;

    public Textfield(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public String getDefaultOpenTemplate() {
        return TEMPLATE;
    }

    protected String getDefaultTemplate() {
        return TEMPLATE_CLOSE;
    }

    public void evaluateExtraParams() {
        super.evaluateExtraParams();
        this.addParameter("jqueryaction", JQUERYACTION);
        if (this.size != null) {
            this.addParameter("size", this.findString(this.size));
        }
        if (this.maxlength != null) {
            this.addParameter("maxlength", this.findString(this.maxlength));
        }
        if (this.readonly != null) {
            this.addParameter("readonly", this.findValue(this.readonly, Boolean.class));
        }
        if (this.id == null || this.id.length() == 0) {
            int nextInt = RANDOM.nextInt();
            nextInt = nextInt == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(nextInt);
            this.id = "textfield_" + String.valueOf(nextInt);
            this.addParameter("id", this.id);
        }
    }

    @StrutsTagSkipInheritance
    public void setTheme(String theme) {
        super.setTheme(theme);
    }

    public String getTheme() {
        return "jquery";
    }

    @StrutsTagAttribute(description="HTML maxlength attribute", type="Integer")
    public void setMaxlength(String maxlength) {
        this.maxlength = maxlength;
    }

    @StrutsTagAttribute(description="Whether the input is readonly", type="Boolean", defaultValue="false")
    public void setReadonly(String readonly) {
        this.readonly = readonly;
    }

    @StrutsTagAttribute(description="HTML size attribute", type="Integer")
    public void setSize(String size) {
        this.size = size;
    }
}

