/*
 * Decompiled with CFR 0.152.
 */
package com.jgeppert.struts2.jquery.components;

import com.jgeppert.struts2.jquery.components.AbstractFormElement;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.annotations.StrutsTagSkipInheritance;

@StrutsTag(name="textarea", tldTagClass="com.jgeppert.struts2.jquery.views.jsp.ui.TextareaTag", description="Render HTML textarea providing content from remote call via AJAX")
public class Textarea
extends AbstractFormElement {
    public static final String TEMPLATE = "textarea";
    public static final String TEMPLATE_CLOSE = "textarea-close";
    public static final String COMPONENT_NAME = Textarea.class.getName();
    private static final transient Random RANDOM = new Random();
    public static final String JQUERYACTION = "container";
    protected String cols;
    protected String readonly;
    protected String rows;
    protected String wrap;

    public Textarea(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public String getDefaultOpenTemplate() {
        return TEMPLATE;
    }

    protected String getDefaultTemplate() {
        return TEMPLATE_CLOSE;
    }

    public void evaluateExtraParams() {
        super.evaluateExtraParams();
        this.addParameter("jqueryaction", JQUERYACTION);
        if (this.readonly != null) {
            this.addParameter("readonly", this.findValue(this.readonly, Boolean.class));
        }
        if (this.cols != null) {
            this.addParameter("cols", this.findString(this.cols));
        }
        if (this.rows != null) {
            this.addParameter("rows", this.findString(this.rows));
        }
        if (this.wrap != null) {
            this.addParameter("wrap", this.findString(this.wrap));
        }
        if (this.id == null || this.id.length() == 0) {
            int nextInt = RANDOM.nextInt();
            nextInt = nextInt == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(nextInt);
            this.id = "textarea_" + String.valueOf(nextInt);
            this.addParameter("id", this.id);
        }
    }

    @StrutsTagSkipInheritance
    public void setTheme(String theme) {
        super.setTheme(theme);
    }

    public String getTheme() {
        return "jquery";
    }

    @StrutsTagAttribute(description="HTML cols attribute", type="Integer")
    public void setCols(String cols) {
        this.cols = cols;
    }

    @StrutsTagAttribute(description="Whether the textarea is readonly", type="Boolean", defaultValue="false")
    public void setReadonly(String readonly) {
        this.readonly = readonly;
    }

    @StrutsTagAttribute(description="HTML rows attribute", type="Integer")
    public void setRows(String rows) {
        this.rows = rows;
    }

    @StrutsTagAttribute(description="HTML wrap attribute")
    public void setWrap(String wrap) {
        this.wrap = wrap;
    }
}

