/*
 * #%L
 * SGQ :: Web
 * $Id: BatchAnalyzeViewAction.java 447 2014-04-08 09:01:07Z echatellier $
 * $HeadURL: https://svn.codelutin.com/sgq-ch/tags/sgq-ch-1.1.5/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/BatchAnalyzeViewAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.entities.AnalyzeFile;
import com.herbocailleau.sgq.entities.BatchAnalyze;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action d'affichage du détail d'une analyse.
 * 
 * @author echatellier
 */
public class BatchAnalyzeViewAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected String analyzeId;

    protected BatchAnalyze analyze;

    protected List<AnalyzeFile> analyzeFiles;

    public void setAnalyzeId(String analyzeId) {
        this.analyzeId = analyzeId;
    }

    @Override
    public String execute() throws Exception {
        BatchService batchService = newService(BatchService.class);
        analyze = batchService.getAnalyzeById(analyzeId);
        analyzeFiles = batchService.findAllAnalyzeFilesByAnalyze(analyze);
        return SUCCESS;
    }

    public BatchAnalyze getAnalyze() {
        return analyze;
    }

    public List<AnalyzeFile> getAnalyzeFiles() {
        return analyzeFiles;
    }

    /**
     * Action de suppression d'une analyse.
     * 
     * @return success
     */
    @Action(value="batch-analyze-delete", results={@Result(type="redirectAction", params = {"actionName", "batch-view", "batchId", "${analyze.batch.topiaId}"})})
    public String batchAnalyzeDetele() {
        BatchService batchService = newService(BatchService.class);
        analyze = batchService.getAnalyzeById(analyzeId);
        batchService.deleteAnalyze(analyze);
        return SUCCESS;
    }
}
