/*
 * #%L
 * SGQ :: Web
 * $Id: BatchAnalyzeDownloadAction.java 231 2012-12-17 17:11:19Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/BatchAnalyzeDownloadAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.io.InputStream;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.entities.AnalyzeFile;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action de téléchargement d'un fichier d'analyse.
 * 
 * @author echatellier
 */
public class BatchAnalyzeDownloadAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 307425532542738956L;

    protected String analyzeFileId;

    protected AnalyzeFile analyzeFile;

    public void setAnalyzeFileId(String analyzeFileId) {
        this.analyzeFileId = analyzeFileId;
    }

    @Override
    @Action(results= {@Result(type="stream", params={"inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String execute() throws Exception {

        BatchService batchService = newService(BatchService.class);
        analyzeFile = batchService.getAnalyzeFileById(analyzeFileId);

        return SUCCESS;
    }

    public InputStream getInputStream() {
        BatchService batchService = newService(BatchService.class);
        InputStream inputStream = batchService.getAnalyzeDataStream(analyzeFile);
        return inputStream;
    }

    public String getFilename() {
        return analyzeFile.getName();
    }

    public AnalyzeFile getAnalyzeFile() {
        return analyzeFile;
    }

    @Action(value="batch-file-delete",
        results= {@Result(type="redirectAction", params = {"actionName", "batch-view", "batchId", "${analyzeFile.batch.topiaId}"})})
    public String batchFileDelete() throws Exception {

        BatchService batchService = newService(BatchService.class);
        analyzeFile = batchService.getAnalyzeFileById(analyzeFileId);
        batchService.deleteAnalyzeFile(analyzeFile);

        return SUCCESS;
    }

    @Action(value="batch-analyze-file-delete",
            results= {@Result(type="redirectAction", params = {"actionName", "batch-analyze-view", "analyzeId", "${analyzeFile.batchAnalyze.topiaId}"})})
    public String batchAnalyzeFileDelete() throws Exception {

        BatchService batchService = newService(BatchService.class);
        analyzeFile = batchService.getAnalyzeFileById(analyzeFileId);
        batchService.deleteAnalyzeFile(analyzeFile);

        return SUCCESS;
    }
}
