/*
 * #%L
 * SGQ :: Web
 * $Id: SetupAction.java 320 2013-04-17 08:26:15Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/SetupAction.java $
 * %%
 * Copyright (C) 2012, 2013 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions;

import java.io.File;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action de configuration.
 * 
 * @author echatellier
 */
public class SetupAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected long batchCount;

    protected long analyzeCount;

    protected File file;

    protected File analyzeFile;

    public void setFile(File file) {
        this.file = file;
    }

    public void setAnalyzeFile(File analyzeFile) {
        this.analyzeFile = analyzeFile;
    }

    @Override
    public String execute() throws Exception {
        BatchService batchService = newService(BatchService.class);
        if (file != null) {
            batchService.recoverBatchFile(file);
        }
        if (analyzeFile != null) {
            batchService.recoverAnalyzeFile(analyzeFile);
        }
        batchCount = batchService.getBatchCount();
        analyzeCount = batchService.getAnalyzeCount();
        return SUCCESS;
    }

    public long getBatchCount() {
        return batchCount;
    }
    
    public long getAnalyzeCount() {
        return analyzeCount;
    }
}
