/*
 * #%L
 * SGQ :: Web
 * $Id: SearchResultAction.java 356 2013-05-07 15:25:38Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.1/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/SearchResultAction.java $
 * %%
 * Copyright (C) 2012, 2013 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.util.PagerBean;

import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.model.BatchModel;
import com.herbocailleau.sgq.business.model.SearchModel;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.ProductStatus;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class SearchResultAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    private static final Log log = LogFactory.getLog(SearchResultAction.class);

    protected ReferentialService referentialService;

    protected SearchModel search;

    protected List<BatchModel> batchModels;

    protected List<ProductStatus> productStatuses;

    protected List<String> productCategories;

    protected List<AnalyzeType> analyzeTypes;

    protected PagerBean pager;

    protected int page;

    public SearchModel getSearch() {
        if (search == null) {
            search = new SearchModel();
        }
        return search;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void parseParameters() throws Exception {
        // traite ici les parametres que struts aura du mal a gere ti seul
        referentialService = newService(ReferentialService.class);

        // search.productStatus
        String[] productStatusIds = getParameters("search_productStatus");
        List<ProductStatus> productStatus = new ArrayList<ProductStatus>();
        if (productStatusIds != null) {
            for (String productStatusId : productStatusIds) {
                productStatus.add(referentialService.getProductStatusById(productStatusId));
            }
        }
        getSearch().setProductStatus(productStatus);

        // search.analyzeCategories
        String[] analyzeTypeIds = getParameters("search_analyzeType");
        List<AnalyzeType> types = new ArrayList<AnalyzeType>();
        if (analyzeTypeIds != null) {
            for (String analyzeTypeId : analyzeTypeIds) {
                types.add(referentialService.findAnalyzeTypeById(analyzeTypeId));
            }
        }
        getSearch().setAnalyzeTypes(types);

        // dates
        String dateBegin = getParameter("search_beginDate");
        try {
            if (StringUtils.isNotBlank(dateBegin)) {
                getSearch().setBeginDate(SgqUtils.parseSgqDate(dateBegin));
            }
        } catch (ParseException ex) {
            addActionError("Impossible de parser la date " + dateBegin);
        }

        // dates
        String dateEnd = getParameter("search_endDate");
        try {
            if (StringUtils.isNotBlank(dateEnd)) {
                getSearch().setEndDate(SgqUtils.parseSgqDate(dateEnd));
            }
        } catch (ParseException ex) {
            addActionError("Impossible de parser la date " + dateEnd);
        }
    }

    @Override
    public String execute() throws Exception {
        parseParameters();

        productStatuses = referentialService.findAllProductStatus();
        productCategories = referentialService.findAllProductCategories();
        analyzeTypes = referentialService.findAllAnalyzeTypes();
        BatchService batchService = newService(BatchService.class);
        Pair<List<BatchModel>, Long> searchResult = batchService.searchBatch(getSearch(), page * ITEM_PER_PAGE, ITEM_PER_PAGE);
        batchModels = searchResult.getKey();
        long totalCount = searchResult.getValue();
        pager = getPager(page, ITEM_PER_PAGE, totalCount);
        return SUCCESS;
    }

    public List<BatchModel> getBatchModels() {
        return batchModels;
    }

    public List<ProductStatus> getProductStatuses() {
        return productStatuses;
    }

    public List<String> getProductCategories() {
        return productCategories;
    }

    public List<AnalyzeType> getAnalyzeTypes() {
        return analyzeTypes;
    }

    public PagerBean getPager() {
        return pager;
    }
    
    @Action(value="search-export", results= {@Result(type="stream", params={"contentType", "text/csv", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String export() throws Exception {
        parseParameters();
        return SUCCESS;
    }

    public InputStream getInputStream() {
        BatchService batchService = newService(BatchService.class);
        InputStream result = null;
        try {
            result = batchService.searchBatchASCsv(search);
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't get csv stream", ex);
            }
        }
        return result;
    }

    public String getFilename() {
        return "search.csv";
    }
}
