/*
 * #%L
 * SGQ :: Web
 * $Id: PlaceAction.java 346 2013-04-30 09:54:34Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.1/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/PlaceAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.herbocailleau.sgq.business.model.PresentationModel;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.entities.Zone;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class PlaceAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    protected ReferentialService referentialService;

    protected List<Zone> zones;

    protected List<Place> places;

    protected Zone zone;

    protected Place place;

    protected String placeId;

    protected String product;

    protected Map<Place, List<PresentationModel>> batchPresentations;

    public Zone getZone() {
        return zone;
    }

    public void setZone(Zone zone) {
        this.zone = zone;
    }

    public void setPlaceId(String placeId) {
        this.placeId = placeId;
    }

    public String getProduct() {
        return product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    @Override
    public String execute() throws Exception {
        zones = Arrays.asList(Zone.values());
        referentialService = newService(ReferentialService.class);
        places = referentialService.getPlaces(zone);
        if (StringUtils.isNotEmpty(placeId)) {
            place = referentialService.getPlaceById(placeId);

            // fix rapide pour saisie incohérente
            if (zone != null && place.getZone() != zone) {
                place = null;
            }
        }
        BatchService batchService = newService(BatchService.class);
        if (place != null || StringUtils.isNotBlank(product)) {
            batchPresentations = batchService.findAllBatchPerPlacesAndProduct(zone, place, product);
        }
        return SUCCESS;
    }

    public List<Zone> getZones() {
        return zones;
    }

    public List<Place> getPlaces() {
        return places;
    }

    public Place getPlace() {
        return place;
    }

    public Map<Place, List<PresentationModel>> getBatchPresentations() {
        return batchPresentations;
    }
}
