/*
 * #%L
 * SGQ :: Business
 * $Id: DatabaseMigration.java 394 2013-06-19 08:44:58Z echatellier $
 * $HeadURL: https://svn.codelutin.com/sgq-ch/tags/sgq-ch-1.1.5/sgq-business/src/main/java/com/herbocailleau/sgq/business/migration/DatabaseMigration.java $
 * %%
 * Copyright (C) 2012, 2013 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */
package com.herbocailleau.sgq.business.migration;

import java.util.List;

import org.nuiton.topia.migration.TopiaMigrationCallbackByClass;
import org.nuiton.util.Version;

import com.herbocailleau.sgq.SGQDAOHelper;

/**
 * Definition de la migration topia.
 * 
 * @author Eric Chatellier
 */
public class DatabaseMigration extends TopiaMigrationCallbackByClass {

    protected static final Version VERSION_11 = new Version("1.1");

    public DatabaseMigration() {
        super(new MigrationResolver());
    }
    
    @Override
    public Version[] getAvailableVersions() {
        Version[] result = new Version[] { VERSION_11};
        return result;
    }

    @Override
    public Version getApplicationVersion() {
        return new Version(SGQDAOHelper.getModelVersion());
    }

    @Override
    public boolean askUser(Version dbVersion, List<Version> versions) {
        return true;
    }

    protected static class MigrationResolver implements MigrationCallBackForVersionResolver {
        /*
         * @see org.nuiton.topia.migration.TopiaMigrationCallbackByClass.MigrationCallBackForVersionResolver#getCallBack(org.nuiton.util.Version)
         */
        @Override
        public Class<? extends MigrationCallBackForVersion> getCallBack(Version version) {
            Class<? extends MigrationCallBackForVersion> result = null;
            
            if (version.equals(VERSION_11)) {
                result = MigrationV0V11.class;
            }
            return result;
        }
        
    }
}
