/*
 * #%L
 * SGQ :: Business
 * $Id: Zone.java 374 2013-05-27 17:50:32Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.4/sgq-business/src/main/java/com/herbocailleau/sgq/entities/Zone.java $
 * %%
 * Copyright (C) 2012,2013 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.entities;

/**
 * Zones.
 * 
 * @author echatellier
 */
public enum Zone {
    /** Zone de conditionnement. */
    ZC(99997),
    /** Zone d'entrepot-fabrication. Endroit depuis lequel le fichier FIF_HIST.txt est importé. */
    ZE(99999),
    /** Zone de partance-expedition. Endroit depuis lequel le fichier FIC_HIST.txt est importé. */
    ZP(99998);

    private int client;
    
    private Zone(int client) {
        this.client = client;
    }
    
    public int getClient() {
        return client;
    }
}
