package com.herbocailleau.sgq.entities;

import java.util.Collection;
import java.util.Date;
import org.nuiton.topia.persistence.TopiaEntity;

public interface Presentation extends TopiaEntity {

    String PROPERTY_QUANTITY = "quantity";

    String PROPERTY_DMESD = "dmesd";

    String PROPERTY_ORIGINAL = "original";

    String PROPERTY_BATCH = "batch";

    String PROPERTY_PRESENTATION_CODE = "presentationCode";

    String PROPERTY_INVENTORY_PLACES = "inventoryPlaces";

    void setQuantity(double quantity);

    double getQuantity();

    void setDmesd(Date dmesd);

    Date getDmesd();

    void setOriginal(boolean original);

    boolean isOriginal();

    boolean getOriginal();

    void setBatch(Batch batch);

    Batch getBatch();

    void setPresentationCode(PresentationCode presentationCode);

    PresentationCode getPresentationCode();

    void addInventoryPlaces(Place inventoryPlaces);

    void addAllInventoryPlaces(Collection<Place> inventoryPlaces);

    void setInventoryPlaces(Collection<Place> inventoryPlaces);

    void removeInventoryPlaces(Place inventoryPlaces);

    void clearInventoryPlaces();

    Collection<Place> getInventoryPlaces();

    Place getInventoryPlacesByTopiaId(String topiaId);

    int sizeInventoryPlaces();

    boolean isInventoryPlacesEmpty();

} //Presentation
