/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.concurrent.collector;

import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.reflection.GenericReflection;
import com.helger.base.state.ESuccess;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.commons.concurrent.collector.AbstractConcurrentCollector;
import com.helger.commons.concurrent.collector.IConcurrentPerformer;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentCollectorMultiple<DATATYPE>
extends AbstractConcurrentCollector<DATATYPE> {
    public static final int DEFAULT_MAX_PERFORM_COUNT = 50;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentCollectorMultiple.class);
    @Nonnegative
    private final int m_nMaxPerformCount;
    private IConcurrentPerformer<List<DATATYPE>> m_aPerformer;

    public ConcurrentCollectorMultiple() {
        this(100, 50);
    }

    public ConcurrentCollectorMultiple(@Nonnegative int n, @Nonnegative int n2) {
        super(n);
        ValueEnforcer.isGT0((int)n2, (String)"MaxPerformCount");
        ValueEnforcer.isTrue((n2 <= n ? 1 : 0) != 0, () -> "max perform size is illegal " + n2 + " - must be <= queue size " + n);
        this.m_nMaxPerformCount = n2;
    }

    public ConcurrentCollectorMultiple(@NonNull BlockingQueue<Object> blockingQueue) {
        this(blockingQueue, 50);
    }

    public ConcurrentCollectorMultiple(@NonNull BlockingQueue<Object> blockingQueue, @Nonnegative int n) {
        super(blockingQueue);
        this.m_nMaxPerformCount = ValueEnforcer.isGT0((int)n, (String)"MaxPerformCount");
    }

    @Nonnegative
    public final int getMaxPerformCount() {
        return this.m_nMaxPerformCount;
    }

    public final @Nullable IConcurrentPerformer<List<DATATYPE>> getPerformer() {
        return this.m_aPerformer;
    }

    public final @NonNull ConcurrentCollectorMultiple<DATATYPE> setPerformer(@NonNull IConcurrentPerformer<List<DATATYPE>> iConcurrentPerformer) {
        if (this.m_aPerformer != null) {
            throw new IllegalStateException("Another performer is already set!");
        }
        this.m_aPerformer = (IConcurrentPerformer)ValueEnforcer.notNull(iConcurrentPerformer, (String)"Performer");
        return this;
    }

    private @NonNull ESuccess _perform(@NonNull ICommonsList<DATATYPE> iCommonsList) {
        if (iCommonsList.isNotEmpty()) {
            try {
                this.m_aPerformer.runAsync((List<ICommonsList<DATATYPE>>)iCommonsList);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to perform actions on " + iCommonsList.size() + " objects with performer " + String.valueOf(this.m_aPerformer) + " - objects are lost!", (Throwable)exception);
                return ESuccess.FAILURE;
            }
            iCommonsList.clear();
        }
        return ESuccess.SUCCESS;
    }

    @Override
    public final void collect() {
        if (this.m_aPerformer == null) {
            throw new IllegalStateException("No performer set!");
        }
        try {
            Object e;
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            boolean bl = false;
            while (!EqualsHelper.identityEqual(e = this.m_aQueue.take(), (Object)STOP_QUEUE_OBJECT)) {
                commonsArrayList.add(GenericReflection.uncheckedCast(e));
                while (commonsArrayList.size() < this.m_nMaxPerformCount && !this.m_aQueue.isEmpty()) {
                    e = this.m_aQueue.take();
                    if (EqualsHelper.identityEqual(e, (Object)STOP_QUEUE_OBJECT)) {
                        bl = true;
                        break;
                    }
                    commonsArrayList.add(GenericReflection.uncheckedCast(e));
                }
                this._perform((ICommonsList<DATATYPE>)commonsArrayList);
                if (!bl) continue;
                break;
            }
            this._perform((ICommonsList<DATATYPE>)commonsArrayList);
        }
        catch (InterruptedException interruptedException) {
            LOGGER.error("Error taking elements from queue - queue has been interrupted!!!", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        catch (Throwable throwable) {
            LOGGER.error("Error taking elements from queue - queue has been stopped!!!", throwable);
        }
    }
}

