/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.iterator;

import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.base.EmptyIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class CombinedIterator<ELEMENTTYPE>
implements Iterator<ELEMENTTYPE> {
    private final Iterator<? extends ELEMENTTYPE> m_aIter1;
    private final Iterator<? extends ELEMENTTYPE> m_aIter2;
    private boolean m_bFirstIter;

    public CombinedIterator(@Nullable Iterator<? extends ELEMENTTYPE> iterator, @Nullable Iterator<? extends ELEMENTTYPE> iterator2) {
        this.m_aIter1 = iterator;
        this.m_aIter2 = iterator2;
        this.m_bFirstIter = iterator != null;
    }

    @Override
    public boolean hasNext() {
        boolean bl = false;
        if (this.m_bFirstIter && !(bl = this.m_aIter1.hasNext())) {
            this.m_bFirstIter = false;
        }
        if (!this.m_bFirstIter) {
            bl = this.m_aIter2 != null && this.m_aIter2.hasNext();
        }
        return bl;
    }

    @Override
    public @Nullable ELEMENTTYPE next() {
        if (this.m_bFirstIter) {
            return this.m_aIter1.next();
        }
        if (this.m_aIter2 == null) {
            throw new NoSuchElementException();
        }
        return this.m_aIter2.next();
    }

    @Override
    public void remove() {
        if (this.m_bFirstIter) {
            this.m_aIter1.remove();
        } else {
            if (this.m_aIter2 == null) {
                throw new UnsupportedOperationException();
            }
            this.m_aIter2.remove();
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("iter1", this.m_aIter1).append("iter2", this.m_aIter2).getToString();
    }

    public static <ELEMENTTYPE> @NonNull Iterator<ELEMENTTYPE> create(@Nullable Iterator<ELEMENTTYPE> iterator, @Nullable Iterator<ELEMENTTYPE> iterator2) {
        if (iterator == null && iterator2 == null) {
            return new EmptyIterator();
        }
        if (iterator == null) {
            return iterator2;
        }
        if (iterator2 == null) {
            return iterator;
        }
        return new CombinedIterator<ELEMENTTYPE>(iterator, iterator2);
    }
}

